/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.client.render.area.AreaRenderManager;
import me.desht.pneumaticcraft.common.block.entity.HeatSinkBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.block.entity.RangeManager;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.entity.semiblock.AbstractSemiblockEntity;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdatePressureBlock;
import me.desht.pneumaticcraft.common.particle.AirParticleData;
import me.desht.pneumaticcraft.common.tubemodules.AbstractTubeModule;
import me.desht.pneumaticcraft.common.util.DirectionUtil;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class AirGrateModule
extends AbstractTubeModule {
    private int grateRange;
    private boolean vacuum;
    private final Set<HeatSinkBlockEntity> heatSinks = new HashSet<HeatSinkBlockEntity>();
    private boolean showRange;
    @Nonnull
    private EntityFilter entityFilter = EntityFilter.allow();
    private final Map<BlockPos, Boolean> traceabilityCache = new HashMap<BlockPos, Boolean>();
    private LazyOptional<IItemHandler> itemInsertionCap = null;
    private LazyOptional<IFluidHandler> fluidInsertionCap = null;

    public AirGrateModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public double getWidth() {
        return 16.0;
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.AIR_GRATE_MODULE.get();
    }

    @Override
    public void tickCommon() {
        Level world = this.pressureTube.nonNullLevel();
        BlockPos pos = this.pressureTube.m_58899_();
        if ((world.m_46467_() & 0x1FL) == 0L) {
            this.traceabilityCache.clear();
        }
        int oldGrateRange = this.grateRange;
        this.grateRange = this.calculateRange();
        if (oldGrateRange != this.grateRange) {
            this.onGrateRangeChanged();
        }
        Vec3 tileVec = Vec3.m_82512_((Vec3i)pos).m_82520_((double)this.getDirection().m_122429_() * 0.49, (double)this.getDirection().m_122430_() * 0.49, (double)this.getDirection().m_122431_() * 0.49);
        this.pushEntities(world, pos, tileVec);
    }

    private void onGrateRangeChanged() {
        if (!this.pressureTube.nonNullLevel().f_46443_) {
            this.getTube().getCapability(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY).ifPresent(h -> NetworkHandler.sendToAllTracking((Object)new PacketUpdatePressureBlock(this.getTube(), null, h.getSideLeaking(), h.getAir()), this.getTube()));
        } else if (this.showRange) {
            AreaRenderManager.getInstance().showArea(RangeManager.getFrame(this.getAffectedAABB()), 1627373664, this.pressureTube, false);
        }
    }

    @Override
    public void tickServer() {
        super.tickServer();
        this.coolHeatSinks();
    }

    @Override
    public void onNeighborBlockUpdate() {
        this.itemInsertionCap = null;
        this.fluidInsertionCap = null;
    }

    private AABB getAffectedAABB() {
        BlockPos pos = this.pressureTube.m_58899_().m_5484_(this.getDirection(), this.grateRange + 1);
        return new AABB(pos).m_82400_((double)this.grateRange);
    }

    private int calculateRange() {
        float range = this.pressureTube.getPressure() * 4.0f;
        boolean bl = this.vacuum = range < 0.0f;
        if (this.vacuum) {
            range *= -4.0f;
        }
        return (int)range;
    }

    private void pushEntities(Level world, BlockPos pos, Vec3 traceVec) {
        AABB bbBox = this.getAffectedAABB();
        List entities = world.m_6443_(Entity.class, bbBox, (Predicate)this.entityFilter);
        double d0 = this.grateRange * 3;
        int entitiesMoved = 0;
        for (Entity entity : entities) {
            double z;
            double d4;
            double d5;
            if (this.ignoreEntity(entity) || !entity.m_6084_() || !this.rayTraceOK(entity, traceVec)) continue;
            if (!entity.m_9236_().f_46443_) {
                this.tryInsertion(traceVec, entity);
            }
            double x = (entity.m_20185_() - (double)pos.m_123341_() - 0.5) / d0;
            double y = (entity.m_20186_() + (double)entity.m_20192_() - (double)pos.m_123342_() - 0.5) / d0;
            BlockPos entityPos = entity.m_20183_();
            if (!Block.m_49863_((LevelReader)world, (BlockPos)entityPos, (Direction)Direction.UP) && !world.m_46859_(entityPos)) {
                y -= 0.15;
            }
            if (!((d5 = 1.0 - (d4 = Math.sqrt(x * x + y * y + (z = (entity.m_20189_() - (double)pos.m_123343_() - 0.5) / d0) * z))) > 0.0)) continue;
            d5 *= d5;
            if (this.vacuum) {
                d5 *= -1.0;
            }
            if (entity.m_20096_() && entity instanceof ItemEntity) {
                entity.m_20256_(entity.m_20184_().m_82520_(0.0, 0.25, 0.0));
            }
            entity.m_6478_(MoverType.SELF, new Vec3(x * d5, y * d5, z * d5));
            ++entitiesMoved;
            if (!world.f_46443_ || !(world.f_46441_.m_188500_() < 0.2)) continue;
            if (this.vacuum) {
                world.m_7106_((ParticleOptions)AirParticleData.DENSE, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), -x, -y, -z);
                continue;
            }
            world.m_7106_((ParticleOptions)AirParticleData.DENSE, (double)pos.m_123341_() + 0.5 + (double)this.getDirection().m_122429_(), (double)pos.m_123342_() + 0.5 + (double)this.getDirection().m_122430_(), (double)pos.m_123343_() + 0.5 + (double)this.getDirection().m_122431_(), x, y, z);
        }
        if (!world.f_46443_) {
            int usage = this.pressureTube.getPressure() > 0.0f ? -2 : 2;
            this.pressureTube.addAir(entitiesMoved * usage);
        }
    }

    private void tryInsertion(Vec3 traceVec, Entity entity) {
        if (entity instanceof ItemEntity && this.isCloseEnough(entity, traceVec)) {
            this.tryItemInsertion((ItemEntity)entity);
        } else if (entity instanceof ExperienceOrb && this.isCloseEnough(entity, traceVec)) {
            this.tryOrbInsertion((ExperienceOrb)entity);
        }
    }

    private void tryItemInsertion(ItemEntity entity) {
        ItemStack stack = entity.m_32055_();
        this.getItemInsertionCap().ifPresent(handler -> {
            ItemStack excess = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
            if (excess.m_41619_()) {
                entity.m_146870_();
            } else {
                entity.m_32045_(excess);
            }
        });
    }

    private void tryOrbInsertion(ExperienceOrb entity) {
        this.getFluidInsertionCap().ifPresent(handler -> {
            if (PneumaticCraftUtils.fillTankWithOrb(handler, entity, IFluidHandler.FluidAction.EXECUTE)) {
                entity.m_146870_();
            }
        });
    }

    private boolean isCloseEnough(Entity entity, Vec3 traceVec) {
        return entity.m_20238_(traceVec) < 1.0;
    }

    private boolean ignoreEntity(Entity entity) {
        if (entity instanceof Player) {
            return ((Player)entity).m_7500_() || entity.m_6144_() || entity.m_5833_();
        }
        if (entity instanceof ItemEntity || entity instanceof ExperienceOrb) {
            return false;
        }
        return !entity.m_6094_() || entity instanceof AbstractSemiblockEntity;
    }

    private boolean rayTraceOK(Entity entity, Vec3 traceVec) {
        BlockPos pos = BlockPos.m_274446_((Position)entity.m_20299_(0.0f));
        return this.traceabilityCache.computeIfAbsent(pos, k -> {
            Vec3 entityVec = new Vec3(entity.m_20185_(), entity.m_20186_() + (double)entity.m_20192_(), entity.m_20189_());
            ClipContext ctx = new ClipContext(entityVec, traceVec, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entity);
            BlockHitResult trace = entity.m_20193_().m_45547_(ctx);
            return trace.m_82425_().equals((Object)this.pressureTube.m_58899_());
        });
    }

    private LazyOptional<IItemHandler> getItemInsertionCap() {
        if (this.itemInsertionCap == null) {
            for (Direction dir : DirectionUtil.VALUES) {
                LazyOptional cap;
                BlockEntity te = this.pressureTube.nonNullLevel().m_7702_(this.pressureTube.m_58899_().m_121945_(dir));
                if (te == null || !(cap = te.getCapability(ForgeCapabilities.ITEM_HANDLER, dir.m_122424_())).isPresent() || te.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_()).isPresent()) continue;
                this.itemInsertionCap = cap;
                this.itemInsertionCap.addListener(l -> {
                    this.itemInsertionCap = null;
                });
                break;
            }
            if (this.itemInsertionCap == null) {
                this.itemInsertionCap = LazyOptional.empty();
            }
        }
        return this.itemInsertionCap;
    }

    private LazyOptional<IFluidHandler> getFluidInsertionCap() {
        if (this.fluidInsertionCap == null) {
            for (Direction dir : DirectionUtil.VALUES) {
                LazyOptional cap;
                BlockEntity te = this.pressureTube.nonNullLevel().m_7702_(this.pressureTube.m_58899_().m_121945_(dir));
                if (te == null || !(cap = te.getCapability(ForgeCapabilities.FLUID_HANDLER, dir.m_122424_())).isPresent()) continue;
                this.fluidInsertionCap = cap;
                this.fluidInsertionCap.addListener(l -> {
                    this.fluidInsertionCap = null;
                });
                break;
            }
            if (this.fluidInsertionCap == null) {
                this.fluidInsertionCap = LazyOptional.empty();
            }
        }
        return this.fluidInsertionCap;
    }

    private void coolHeatSinks() {
        if (this.grateRange >= 2) {
            int curTeIndex = (int)(this.pressureTube.nonNullLevel().m_46467_() % 27L);
            BlockPos curPos = this.pressureTube.m_58899_().m_5484_(this.dir, 2).m_7918_(-1 + curTeIndex % 3, -1 + curTeIndex / 3 % 3, -1 + curTeIndex / 9 % 3);
            BlockEntity te = this.pressureTube.nonNullLevel().m_7702_(curPos);
            if (te instanceof HeatSinkBlockEntity) {
                this.heatSinks.add((HeatSinkBlockEntity)te);
            }
            Iterator<HeatSinkBlockEntity> iterator = this.heatSinks.iterator();
            int tubesCooled = 0;
            while (iterator.hasNext()) {
                HeatSinkBlockEntity heatSink = iterator.next();
                if (heatSink.m_58901_()) {
                    iterator.remove();
                    continue;
                }
                for (int i = 0; i < 4; ++i) {
                    heatSink.onFannedByAirGrate();
                }
                ++tubesCooled;
            }
            if (tubesCooled > 0) {
                this.pressureTube.addAir(-(5 + tubesCooled / 3));
            }
        }
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.vacuum = tag.m_128471_("vacuum");
        this.grateRange = tag.m_128451_("grateRange");
        String f = tag.m_128461_("entityFilter");
        this.entityFilter = f.isEmpty() ? EntityFilter.allow() : EntityFilter.fromString(f, EntityFilter.allow());
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128379_("vacuum", this.vacuum);
        tag.m_128405_("grateRange", this.grateRange);
        if (this.entityFilter != EntityFilter.allow()) {
            tag.m_128359_("entityFilter", this.entityFilter.toString());
        }
        return tag;
    }

    @Override
    public void addInfo(List<Component> curInfo) {
        super.addInfo(curInfo);
        String k = this.grateRange == 0 ? "idle" : (this.vacuum ? "attracting" : "repelling");
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.airGrateModule." + k, new Object[0]).m_130940_(ChatFormatting.WHITE));
        if (this.grateRange != 0) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.message.misc.range", this.grateRange).m_130940_(ChatFormatting.WHITE));
        }
        if (this.entityFilter != EntityFilter.allow()) {
            curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.gui.entityFilter.show", this.entityFilter.toString()).m_130940_(ChatFormatting.WHITE));
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public AABB getRenderBoundingBox() {
        return new AABB(this.pressureTube.m_58899_().m_5484_(this.getDirection(), this.grateRange + 1)).m_82400_((double)(this.grateRange * 2));
    }

    @Nonnull
    public EntityFilter getEntityFilter() {
        return this.entityFilter;
    }

    public void setEntityFilter(@Nonnull EntityFilter filter) {
        this.entityFilter = filter;
        this.setChanged();
    }

    public boolean isShowRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
        if (showRange) {
            AreaRenderManager.getInstance().showArea(RangeManager.getFrame(this.getAffectedAABB()), 1627373664, this.pressureTube, false);
        } else {
            AreaRenderManager.getInstance().removeHandlers(this.pressureTube);
        }
        this.setChanged();
    }

    @Override
    public void onRemoved() {
        if (this.pressureTube.nonNullLevel().f_46443_) {
            AreaRenderManager.getInstance().removeHandlers(this.pressureTube);
        }
    }
}

