/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import java.util.List;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneEmittingModule;
import me.desht.pneumaticcraft.common.tubemodules.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class FlowDetectorModule
extends AbstractRedstoneEmittingModule
implements IInfluenceDispersing {
    public float rotation;
    public float oldRotation;
    private int flow;
    private int oldFlow;

    public FlowDetectorModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public void tickCommon() {
        super.tickCommon();
        this.oldRotation = this.rotation;
        this.rotation += (float)this.getRedstoneLevel() / 100.0f;
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.FLOW_DETECTOR_MODULE.get();
    }

    @Override
    public void tickServer() {
        super.tickServer();
        if (this.setRedstone(this.flow / 5)) {
            this.pressureTube.sendDescriptionPacket();
        }
        this.oldFlow = this.flow;
        this.flow = 0;
    }

    @Override
    public int getMaxDispersion() {
        return Integer.MAX_VALUE;
    }

    @Override
    public void onAirDispersion(int amount) {
        this.flow += amount;
    }

    @Override
    public void addInfo(List<Component> curInfo) {
        super.addInfo(curInfo);
        curInfo.add((Component)PneumaticCraftUtils.xlate("pneumaticcraft.waila.flowModule.level", this.oldFlow));
    }

    @Override
    public boolean isInline() {
        return true;
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.rotation = tag.m_128457_("rotation");
        this.oldFlow = tag.m_128451_("flow");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        super.writeToNBT(tag);
        tag.m_128350_("rotation", this.rotation);
        tag.m_128405_("flow", this.oldFlow);
        return tag;
    }

    @Override
    public boolean canUpgrade() {
        return false;
    }

    @Override
    public boolean isInlineAndFocused(PressureTubeBlock.TubeHitInfo hitInfo) {
        return hitInfo.dir() == this.getDirection();
    }
}

