/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.tubemodules;

import me.desht.pneumaticcraft.api.PNCCapabilities;
import me.desht.pneumaticcraft.api.tileentity.IAirHandlerMachine;
import me.desht.pneumaticcraft.common.block.PressureTubeBlock;
import me.desht.pneumaticcraft.common.block.entity.PressureTubeBlockEntity;
import me.desht.pneumaticcraft.common.capabilities.CapabilityCache;
import me.desht.pneumaticcraft.common.core.ModItems;
import me.desht.pneumaticcraft.common.tubemodules.AbstractRedstoneReceivingModule;
import me.desht.pneumaticcraft.common.tubemodules.IInfluenceDispersing;
import me.desht.pneumaticcraft.common.util.CapabilityUtils;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.util.LazyOptional;

public class VacuumModule
extends AbstractRedstoneReceivingModule
implements IInfluenceDispersing {
    private final CapabilityCache<IAirHandlerMachine> neighbourAirHandlerCache = new CapabilityCache();
    public float rotation;
    public float oldRotation;
    private int lastAmount = 0;

    public VacuumModule(Direction dir, PressureTubeBlockEntity pressureTube) {
        super(dir, pressureTube);
    }

    @Override
    public Item getItem() {
        return (Item)ModItems.VACUUM_MODULE.get();
    }

    @Override
    public void tickCommon() {
        this.oldRotation = this.rotation;
        this.rotation += (float)this.lastAmount / 5.0f;
    }

    @Override
    public void onNeighborBlockUpdate() {
        super.onNeighborBlockUpdate();
        this.neighbourAirHandlerCache.clear();
    }

    @Override
    public void tickServer() {
        LazyOptional<IAirHandlerMachine> neighbourCap;
        super.tickServer();
        int prevLast = this.lastAmount;
        PressureTubeBlockEntity tube = this.getTube();
        if (tube.getPressure() >= 2.0f && (neighbourCap = this.getCachedNeighbourAirHandler()).isPresent() && this.getReceivingRedstoneLevel() == 0) {
            int toAdd = (int)(-10.0f * (this.upgraded ? 7.41f : 1.0f));
            int toTake = (int)(-4.0f * (this.upgraded ? 5.06f : 1.0f));
            this.lastAmount = neighbourCap.map(h -> {
                int air = h.getAir();
                float pressure = h.getPressure();
                h.addAir(toTake);
                return PneumaticCraftUtils.epsilonEquals(pressure, h.getPressure()) ? 0 : air - h.getAir();
            }).orElse(0);
            if (this.lastAmount != 0) {
                tube.addAir(toAdd * -this.lastAmount / toTake);
            }
        } else {
            this.lastAmount = 0;
        }
        if (prevLast != this.lastAmount) {
            tube.sendDescriptionPacket();
        }
    }

    @Override
    public boolean canUpgrade() {
        return true;
    }

    @Override
    public boolean isInline() {
        return true;
    }

    public int getLastAmount() {
        return this.lastAmount;
    }

    public void setLastAmount(int lastAmount) {
        this.lastAmount = lastAmount;
    }

    private LazyOptional<IAirHandlerMachine> getCachedNeighbourAirHandler() {
        LazyOptional<IAirHandlerMachine> cap = this.neighbourAirHandlerCache.get();
        if (cap.isPresent()) {
            return cap;
        }
        return this.neighbourAirHandlerCache.set(CapabilityUtils.getNeighbourCap(PNCCapabilities.AIR_HANDLER_MACHINE_CAPABILITY, this.pressureTube, this.dir));
    }

    @Override
    public int getMaxDispersion() {
        return 0;
    }

    @Override
    public void onAirDispersion(int amount) {
    }

    @Override
    public void readFromNBT(CompoundTag tag) {
        super.readFromNBT(tag);
        this.lastAmount = tag.m_128451_("lastAmount");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag tag) {
        tag.m_128405_("lastAmount", this.lastAmount);
        return super.writeToNBT(tag);
    }

    @Override
    public boolean isInlineAndFocused(PressureTubeBlock.TubeHitInfo hitInfo) {
        return true;
    }
}

