/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;

public class ItemStackHandlerIterable
implements Iterable<ItemStack> {
    private final IItemHandlerModifiable itemStackHandler;

    public ItemStackHandlerIterable(IItemHandlerModifiable itemStackHandler) {
        this.itemStackHandler = itemStackHandler;
    }

    @Override
    public Iterator<ItemStack> iterator() {
        return new Iterator<ItemStack>(){
            private int curIndex = 0;

            @Override
            public boolean hasNext() {
                return this.curIndex < ItemStackHandlerIterable.this.itemStackHandler.getSlots();
            }

            @Override
            public ItemStack next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ItemStackHandlerIterable.this.itemStackHandler.getStackInSlot(this.curIndex++);
            }

            @Override
            public void remove() {
                if (this.curIndex == 0) {
                    throw new IllegalStateException("First call next()!");
                }
                ItemStackHandlerIterable.this.itemStackHandler.setStackInSlot(this.curIndex - 1, ItemStack.f_41583_);
            }
        };
    }

    public Stream<ItemStack> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

