/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.tesla_coil;

import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBeltCallbacks;
import com.mrh0.createaddition.blocks.tesla_coil.TeslaCoilBlock;
import com.mrh0.createaddition.config.Config;
import com.mrh0.createaddition.energy.BaseElectricBlockEntity;
import com.mrh0.createaddition.index.CABlocks;
import com.mrh0.createaddition.index.CADamageTypes;
import com.mrh0.createaddition.index.CAEffects;
import com.mrh0.createaddition.index.CARecipes;
import com.mrh0.createaddition.index.CASounds;
import com.mrh0.createaddition.recipe.charging.ChargingRecipe;
import com.mrh0.createaddition.sound.CASoundScapes;
import com.mrh0.createaddition.util.Util;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.BeltProcessingBehaviour;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class TeslaCoilBlockEntity
extends BaseElectricBlockEntity
implements IHaveGoggleInformation {
    private Optional<ChargingRecipe> recipeCache = Optional.empty();
    private final ItemStackHandler inputInv = new ItemStackHandler(1);
    private int chargeAccumulator;
    protected int poweredTimer = 0;
    public BeltProcessingBehaviour processingBehaviour;
    int dmgTick = 0;
    int zapTimer = 200;

    public TeslaCoilBlockEntity(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    @Override
    public int getCapacity() {
        return Util.max((Integer)Config.TESLA_COIL_CAPACITY.get(), (Integer)Config.TESLA_COIL_CHARGE_RATE.get(), (Integer)Config.TESLA_COIL_RECIPE_CHARGE_RATE.get());
    }

    @Override
    public int getMaxIn() {
        return (Integer)Config.TESLA_COIL_MAX_INPUT.get();
    }

    @Override
    public int getMaxOut() {
        return 0;
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.processingBehaviour = new BeltProcessingBehaviour((SmartBlockEntity)this).whenItemEnters((s, i) -> TeslaCoilBeltCallbacks.onItemReceived(s, i, this)).whileItemHeld((s, i) -> TeslaCoilBeltCallbacks.whenItemHeld(s, i, this));
        behaviours.add((BlockEntityBehaviour)this.processingBehaviour);
    }

    @Override
    public boolean isEnergyInput(Direction side) {
        return side != ((Direction)this.m_58900_().m_61143_((Property)TeslaCoilBlock.FACING)).m_122424_();
    }

    @Override
    public boolean isEnergyOutput(Direction side) {
        return false;
    }

    public int getConsumption() {
        return (Integer)Config.TESLA_COIL_CHARGE_RATE.get();
    }

    protected float getItemCharge(IEnergyStorage energy) {
        if (energy == null) {
            return 0.0f;
        }
        return (float)energy.getEnergyStored() / (float)energy.getMaxEnergyStored();
    }

    protected BeltProcessingBehaviour.ProcessingResult onCharge(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        BeltProcessingBehaviour.ProcessingResult res = this.chargeCompundAndStack(transported, handler);
        return res;
    }

    private void doDmg() {
        this.localEnergy.internalConsumeEnergy((Integer)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get());
        BlockPos origin = this.m_58899_().m_121945_(((Direction)this.m_58900_().m_61143_((Property)TeslaCoilBlock.FACING)).m_122424_());
        List ents = this.m_58904_().m_45976_(LivingEntity.class, new AABB(origin).m_82400_((double)((Integer)Config.TESLA_COIL_HURT_RANGE.get()).intValue()));
        boolean zapped = false;
        for (LivingEntity e : ents) {
            if (e == null) {
                return;
            }
            boolean allChain = true;
            for (ItemStack armor : e.m_6168_()) {
                if (armor.m_150930_(Items.f_42467_) || armor.m_150930_(Items.f_42466_) || armor.m_150930_(Items.f_42465_) || armor.m_150930_(Items.f_42464_)) continue;
                allChain = false;
                break;
            }
            if (allChain) continue;
            int dmg = (Integer)Config.TESLA_COIL_HURT_DMG_MOB.get();
            int time = (Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_MOB.get();
            if (e instanceof Player) {
                dmg = (Integer)Config.TESLA_COIL_HURT_DMG_PLAYER.get();
                time = (Integer)Config.TESLA_COIL_HURT_EFFECT_TIME_PLAYER.get();
            }
            if (dmg > 0) {
                e.m_6469_(CADamageTypes.barbedWire(this.f_58857_), (float)dmg);
                if (!zapped) {
                    if (((Boolean)Config.AUDIO_ENABLED.get()).booleanValue()) {
                        this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)CASounds.LOUD_ZAP.get(), SoundSource.BLOCKS, 0.6f, 1.0f);
                    }
                    zapped = true;
                }
            }
            if (time <= 0) continue;
            e.m_7292_(new MobEffectInstance((MobEffect)CAEffects.SHOCKING.get(), time));
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> this::tickAudio);
            return;
        }
        int signal = this.m_58904_().m_277086_(this.m_58899_());
        if (signal > 0 && this.localEnergy.getEnergyStored() >= (Integer)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get()) {
            this.poweredTimer = 10;
        }
        ++this.dmgTick;
        if ((this.dmgTick %= ((Integer)Config.TESLA_COIL_HURT_FIRE_COOLDOWN.get()).intValue()) == 0 && this.localEnergy.getEnergyStored() >= (Integer)Config.TESLA_COIL_HURT_ENERGY_REQUIRED.get() && signal > 0) {
            this.doDmg();
        }
        if (this.poweredTimer > 0) {
            if (this.zapTimer == 0) {
                if (((Boolean)Config.AUDIO_ENABLED.get()).booleanValue()) {
                    this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)CASounds.LITTLE_ZAP.get(), SoundSource.BLOCKS, 0.1f, 1.0f);
                }
                this.zapTimer = this.f_58857_.f_46441_.m_216339_(100, 300);
            }
            --this.zapTimer;
            if (!this.isPoweredState()) {
                ((TeslaCoilBlock)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.f_58857_, this.m_58899_(), true);
            }
            --this.poweredTimer;
        } else if (this.isPoweredState()) {
            ((TeslaCoilBlock)((Object)CABlocks.TESLA_COIL.get())).setPowered(this.f_58857_, this.m_58899_(), false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickAudio() {
        if (!this.isPoweredState()) {
            return;
        }
        if (((Boolean)Config.AUDIO_ENABLED.get()).booleanValue()) {
            CASoundScapes.play(CASoundScapes.AmbienceGroup.TESLA, this.f_58858_, 1.0f);
        }
    }

    public boolean isPoweredState() {
        return (Boolean)this.m_58900_().m_61143_((Property)TeslaCoilBlock.POWERED);
    }

    protected BeltProcessingBehaviour.ProcessingResult chargeCompundAndStack(TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        ItemStack stack = transported.stack;
        if (stack == null) {
            return BeltProcessingBehaviour.ProcessingResult.PASS;
        }
        if (this.chargeStack(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        if (this.chargeRecipe(stack, transported, handler)) {
            this.poweredTimer = 10;
            return BeltProcessingBehaviour.ProcessingResult.HOLD;
        }
        return BeltProcessingBehaviour.ProcessingResult.PASS;
    }

    protected boolean chargeStack(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (!stack.getCapability(ForgeCapabilities.ENERGY).isPresent()) {
            return false;
        }
        IEnergyStorage es = (IEnergyStorage)stack.getCapability(ForgeCapabilities.ENERGY).orElse(null);
        if (es.receiveEnergy(1, true) != 1) {
            return false;
        }
        if (this.localEnergy.getEnergyStored() < stack.m_41613_()) {
            return false;
        }
        this.localEnergy.internalConsumeEnergy(es.receiveEnergy(Math.min(this.getConsumption(), this.localEnergy.getEnergyStored()), false));
        return true;
    }

    private boolean chargeRecipe(ItemStack stack, TransportedItemStack transported, TransportedItemStackHandlerBehaviour handler) {
        if (this.m_58904_() == null) {
            return false;
        }
        if (!this.inputInv.getStackInSlot(0).m_150930_(stack.m_41720_())) {
            this.inputInv.setStackInSlot(0, stack);
            this.recipeCache = this.find(new RecipeWrapper((IItemHandlerModifiable)this.inputInv), this.m_58904_());
            this.chargeAccumulator = 0;
        }
        if (this.recipeCache.isPresent()) {
            ChargingRecipe recipe = this.recipeCache.get();
            int energyRemoved = this.localEnergy.internalConsumeEnergy(Util.min((Integer)Config.TESLA_COIL_RECIPE_CHARGE_RATE.get(), recipe.getEnergy() - this.chargeAccumulator, recipe.getMaxChargeRate()));
            this.chargeAccumulator += energyRemoved;
            if (this.chargeAccumulator >= recipe.getEnergy()) {
                TransportedItemStack remainingStack = transported.copy();
                TransportedItemStack result = transported.copy();
                result.stack = recipe.m_8043_(this.m_58904_().m_9598_()).m_41777_();
                remainingStack.stack.m_41774_(1);
                ArrayList<TransportedItemStack> outList = new ArrayList<TransportedItemStack>();
                outList.add(result);
                handler.handleProcessingOnItem(transported, TransportedItemStackHandlerBehaviour.TransportedResult.convertToAndLeaveHeld(outList, (TransportedItemStack)remainingStack));
                this.chargeAccumulator = 0;
                if (((Boolean)Config.AUDIO_ENABLED.get()).booleanValue()) {
                    this.f_58857_.m_5594_(null, this.f_58858_, (SoundEvent)CASounds.LITTLE_ZAP.get(), SoundSource.BLOCKS, 0.1f, 1.0f);
                }
            }
            return true;
        }
        return false;
    }

    public Optional<ChargingRecipe> find(RecipeWrapper wrapper, Level world) {
        return world.m_7465_().m_44015_(CARecipes.CHARGING_TYPE.get(), (Container)wrapper, world);
    }
}

