/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.client.renderer.entity.species;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import fathertoast.specialmobs.client.renderer.entity.family.SpecialEndermanRenderer;
import fathertoast.specialmobs.common.entity.enderman.RunicEndermanEntity;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class RunicEndermanRenderer
extends SpecialEndermanRenderer {
    public static final ResourceLocation BEAM_TEXTURE_LOCATION = new ResourceLocation("textures/entity/end_crystal/end_crystal_beam.png");
    private static final RenderType BEAM = RenderType.m_110476_((ResourceLocation)BEAM_TEXTURE_LOCATION);

    public RunicEndermanRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void m_7392_(EnderMan entity, float rotation, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        RunicEndermanEntity.BeamState beamState = ((RunicEndermanEntity)entity).getBeamState();
        if (beamState != RunicEndermanEntity.BeamState.OFF) {
            poseStack.m_85836_();
            Vec3 beamVec = entity.m_20252_(partialTicks).m_82490_(32.0);
            Vec3 beamStartPos = entity.m_20299_(partialTicks);
            Vec3 beamEndPos = beamStartPos.m_82549_(beamVec);
            BlockHitResult blockRayTrace = entity.m_9236_().m_45547_(new ClipContext(beamStartPos, beamEndPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
            if (blockRayTrace.m_6662_() != HitResult.Type.MISS) {
                beamVec = blockRayTrace.m_82450_().m_82546_(beamStartPos);
            }
            this.renderBeamAttack(beamState, entity.m_20192_(), (float)beamVec.f_82479_, (float)beamVec.f_82480_, (float)beamVec.f_82481_, partialTicks, entity.f_19797_, poseStack, buffer, packedLight);
            poseStack.m_85849_();
        }
        super.m_7392_(entity, rotation, partialTicks, poseStack, buffer, packedLight);
    }

    protected boolean isBodyVisible(EnderMan entity) {
        RunicEndermanEntity.BeamState beamState = ((RunicEndermanEntity)entity).getBeamState();
        if (beamState != RunicEndermanEntity.BeamState.OFF) {
            float zRot = beamState == RunicEndermanEntity.BeamState.DAMAGING ? 0.25f : 0.6f;
            EndermanModel model = (EndermanModel)this.m_7200_();
            model.f_102812_.f_104203_ = -0.6f;
            model.f_102811_.f_104203_ = -0.6f;
            model.f_102812_.f_104205_ = -zRot;
            model.f_102811_.f_104205_ = zRot;
        }
        return super.m_5933_((LivingEntity)entity);
    }

    private void renderBeamAttack(RunicEndermanEntity.BeamState beamState, float offsetY, float dX, float dY, float dZ, float partialTicks, int tickCount, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        float v1;
        float endScale;
        int c2;
        int c1;
        poseStack.m_85836_();
        float dH = Mth.m_14116_((float)(dX * dX + dZ * dZ));
        float length = Mth.m_14116_((float)(dX * dX + dY * dY + dZ * dZ));
        poseStack.m_85837_(0.0, (double)offsetY, 0.0);
        poseStack.m_252781_(Axis.f_252436_.m_252961_((float)(-Math.atan2(dZ, dX)) - 1.5707964f));
        poseStack.m_252781_(Axis.f_252529_.m_252961_((float)(-Math.atan2(dH, dY)) - 1.5707964f));
        VertexConsumer vertexConsumer = buffer.m_6299_(BEAM);
        PoseStack.Pose lastPose = poseStack.m_85850_();
        Matrix4f pose = lastPose.m_252922_();
        Matrix3f normal = lastPose.m_252943_();
        if (beamState == RunicEndermanEntity.BeamState.DAMAGING) {
            c1 = 0;
            c2 = 255;
            endScale = 1.0f;
            v1 = ((float)tickCount + partialTicks) * -0.01f;
        } else {
            c1 = 100;
            c2 = 100;
            endScale = 0.2f;
            v1 = ((float)tickCount + partialTicks) * 0.006f;
        }
        float v2 = length / 32.0f + v1;
        float u1 = 0.0f;
        float x1 = 0.0f;
        float y1 = 0.75f;
        int resolution = 8;
        for (int n = 1; n <= 8; ++n) {
            float u2 = (float)n / 8.0f;
            float angle = u2 * (float)Math.PI * 2.0f;
            float x2 = Mth.m_14031_((float)angle) * 0.75f;
            float y2 = Mth.m_14089_((float)angle) * 0.75f;
            vertexConsumer.m_252986_(pose, x1 * 0.2f, y1 * 0.2f, 0.0f).m_6122_(c1, c1, c1, 255).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(pose, x1 * endScale, y1 * endScale, length).m_6122_(c2, 100, c2, 255).m_7421_(u1, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(pose, x2 * endScale, y2 * endScale, length).m_6122_(c2, 100, c2, 255).m_7421_(u2, v2).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            vertexConsumer.m_252986_(pose, x2 * 0.2f, y2 * 0.2f, 0.0f).m_6122_(c1, c1, c1, 255).m_7421_(u2, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_252939_(normal, 0.0f, -1.0f, 0.0f).m_5752_();
            x1 = x2;
            y1 = y2;
            u1 = u2;
        }
        poseStack.m_85849_();
    }
}

