/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.bestiary;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.value.AttributeEntry;
import fathertoast.crust.api.config.common.value.AttributeList;
import fathertoast.crust.api.config.common.value.EnvironmentEntry;
import fathertoast.crust.api.config.common.value.EnvironmentList;
import fathertoast.crust.api.config.common.value.LazyRegistryEntryList;
import fathertoast.crust.api.config.common.value.RegistryEntryList;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeCategory;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.util.References;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.registries.ForgeRegistries;

public class BestiaryInfo {
    public final int eggSpotsColor;
    public final float baseScale;
    public final DefaultWeight defaultWeight;
    public final Theme theme;
    public final AttributeList defaultAttributes;
    public final ResourceLocation texture;
    public final ResourceLocation eyesTexture;
    public final ResourceLocation overlayTexture;
    public final ResourceLocation animationTexture;
    public final int experience;
    public final int healTime;
    public final double fallDamageMultiplier;
    public final boolean isImmuneToFire;
    public final boolean isImmuneToBurning;
    public final boolean canBreatheInWater;
    public final boolean ignoreWaterPush;
    public final boolean isDamagedByWater;
    public final boolean allowLeashing;
    public final boolean ignorePressurePlates;
    public final RegistryEntryList<Block> immuneToStickyBlocks;
    public final RegistryEntryList<MobEffect> immuneToPotions;
    public final double rangedAttackDamage;
    public final double rangedAttackSpread;
    public final double rangedWalkSpeed;
    public final int rangedAttackCooldown;
    public final int rangedAttackMaxCooldown;
    public final double rangedAttackMaxRange;

    public static Builder of(MobFamily.Species<?> species, EntityType.Builder<?> typeBuilder) {
        return new Builder(species, typeBuilder);
    }

    private BestiaryInfo(int eggColor, float scale, DefaultWeight weight, Theme spawnTheme, List<AttributeEntry> attributes, ResourceLocation tex, ResourceLocation eyeTex, ResourceLocation ovrTex, ResourceLocation animTex, int xp, int regen, double fallDmg, boolean fireImm, boolean burnImm, boolean drownImm, boolean pushImm, boolean waterDmg, boolean leash, boolean plateImm, Object[] blockImm, Object[] effectImm, double raDmg, double raVar, double raSpd, int raCD, int raMCD, double raRng) {
        this.eggSpotsColor = eggColor;
        this.baseScale = scale;
        this.defaultWeight = weight;
        this.theme = spawnTheme;
        this.defaultAttributes = new AttributeList(attributes);
        this.texture = tex;
        this.eyesTexture = eyeTex;
        this.overlayTexture = ovrTex;
        this.animationTexture = animTex;
        this.experience = xp;
        this.healTime = regen;
        this.fallDamageMultiplier = fallDmg;
        this.isImmuneToFire = fireImm;
        this.isImmuneToBurning = burnImm;
        this.canBreatheInWater = drownImm;
        this.ignoreWaterPush = pushImm;
        this.isDamagedByWater = waterDmg;
        this.allowLeashing = leash;
        this.ignorePressurePlates = plateImm;
        this.immuneToStickyBlocks = new LazyRegistryEntryList(ForgeRegistries.BLOCKS, false, blockImm);
        this.immuneToPotions = new LazyRegistryEntryList(ForgeRegistries.MOB_EFFECTS, false, effectImm);
        this.rangedAttackDamage = raDmg;
        this.rangedAttackSpread = raVar;
        this.rangedWalkSpeed = raSpd;
        this.rangedAttackCooldown = raCD;
        this.rangedAttackMaxCooldown = raMCD;
        this.rangedAttackMaxRange = raRng;
    }

    public static final class Builder {
        private final MobFamily.Species<?> owningSpecies;
        private final EntityType.Builder<?> entityTypeBuilder;
        private boolean colorSet;
        private int eggSpotsColor;
        private DefaultWeight defaultWeight = DefaultWeight.DEFAULT;
        private Theme spawnTheme = Theme.NONE;
        private final List<AttributeEntry> attributes = new ArrayList<AttributeEntry>();
        private float baseScale = 1.0f;
        private ResourceLocation texture;
        private ResourceLocation eyesTexture;
        private ResourceLocation overlayTexture;
        private ResourceLocation animationTexture;
        private int experience = -1;
        private int healTime;
        private double fallDamageMultiplier = 1.0;
        private boolean isImmuneToFire;
        private boolean isImmuneToBurning;
        private boolean canBreatheInWater;
        private boolean ignoreWaterPush;
        private boolean isDamagedByWater;
        private boolean allowLeashing;
        private boolean ignorePressurePlates;
        private final ArrayList<Object> immuneToStickyBlocks = new ArrayList();
        private final ArrayList<Object> immuneToPotions = new ArrayList();
        private double rangedAttackDamage = -1.0;
        private double rangedAttackSpread = -1.0;
        private double rangedWalkSpeed = -1.0;
        private int rangedAttackCooldown = -1;
        private int rangedAttackMaxCooldown = -1;
        private double rangedAttackMaxRange = -1.0;

        private Builder(MobFamily.Species<?> species, EntityType.Builder<?> typeBuilder) {
            this.owningSpecies = species;
            this.entityTypeBuilder = typeBuilder;
            if (species.specialVariantName == null) {
                if (species.family.replaceableTypes[0].m_20672_()) {
                    this.isImmuneToFire = true;
                }
            } else {
                BestiaryInfo parent = species.family.vanillaReplacement.bestiaryInfo;
                this.baseScale = parent.baseScale;
                this.texture = parent.texture;
                this.eyesTexture = parent.eyesTexture;
                this.overlayTexture = parent.overlayTexture;
                this.animationTexture = parent.animationTexture;
                this.experience = parent.experience;
                this.healTime = parent.healTime;
                this.fallDamageMultiplier = parent.fallDamageMultiplier;
                this.isImmuneToFire = parent.isImmuneToFire;
                this.isImmuneToBurning = parent.isImmuneToBurning;
                this.canBreatheInWater = parent.canBreatheInWater;
                this.ignoreWaterPush = parent.ignoreWaterPush;
                this.isDamagedByWater = parent.isDamagedByWater;
                this.allowLeashing = parent.allowLeashing;
                this.ignorePressurePlates = parent.ignorePressurePlates;
                this.immuneToStickyBlocks.addAll(parent.immuneToStickyBlocks.getEntries());
                this.immuneToPotions.addAll(parent.immuneToPotions.getEntries());
                this.setAllRangedStats(parent.rangedAttackDamage, parent.rangedAttackSpread, parent.rangedWalkSpeed, parent.rangedAttackCooldown, parent.rangedAttackMaxCooldown, parent.rangedAttackMaxRange);
            }
        }

        BestiaryInfo build() {
            if (!this.colorSet) {
                throw new IllegalStateException("Species " + this.owningSpecies.name + " has not assigned egg spots color!");
            }
            if (this.experience < 0) {
                throw new IllegalStateException("Family " + this.owningSpecies.family.name + " has not set the base experience value!");
            }
            return new BestiaryInfo(this.eggSpotsColor, this.baseScale, this.defaultWeight, this.spawnTheme, this.attributes, this.texture, this.eyesTexture, this.overlayTexture, this.animationTexture, this.experience, this.healTime, this.fallDamageMultiplier, this.isImmuneToFire, this.isImmuneToBurning, this.canBreatheInWater, this.ignoreWaterPush, this.isDamagedByWater, this.allowLeashing, this.ignorePressurePlates, this.immuneToStickyBlocks.toArray(), this.immuneToPotions.toArray(), this.rangedAttackDamage, this.rangedAttackSpread, this.rangedWalkSpeed, this.rangedAttackCooldown, this.rangedAttackMaxCooldown, this.rangedAttackMaxRange);
        }

        public Builder color(int eggColor) {
            this.eggSpotsColor = eggColor;
            this.colorSet = true;
            return this;
        }

        public Builder weight(DefaultWeight weight) {
            this.defaultWeight = weight;
            return this;
        }

        public Builder theme(Theme theme) {
            this.spawnTheme = theme;
            return this;
        }

        public Builder familySize(float renderScale) {
            if (this.owningSpecies.specialVariantName != null) {
                throw new IllegalStateException("Special variant " + this.owningSpecies.specialVariantName + " cannot set family render scale!");
            }
            this.baseScale = renderScale;
            return this;
        }

        public Builder size(float renderScale, float width, float height) {
            this.baseScale = renderScale;
            this.entityTypeBuilder.m_20699_(width, height);
            return this;
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        public Builder vanillaTexturesAll(String tex, String eyeTex, String ovrTex) {
            return this.vanillaBaseTexture(tex).vanillaEyesTexture(eyeTex).vanillaOverlayTexture(ovrTex);
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        public Builder vanillaTextureWithEyes(String tex, String eyeTex) {
            return this.vanillaBaseTexture(tex).vanillaEyesTexture(eyeTex).noOverlayTexture();
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        public Builder vanillaTextureWithOverlay(String tex, String ovrTex) {
            return this.vanillaBaseTexture(tex).noEyesTexture().vanillaOverlayTexture(ovrTex);
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        public Builder vanillaTextureWithAnimation(String tex, String aniTex) {
            return this.vanillaBaseTexture(tex).noEyesTexture().vanillaAnimationTexture(aniTex);
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        public Builder vanillaTextureBaseOnly(String tex) {
            return this.vanillaBaseTexture(tex).noEyesTexture().noOverlayTexture();
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        private Builder vanillaBaseTexture(String tex) {
            return this.baseTexture(new ResourceLocation(tex));
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        private Builder vanillaEyesTexture(String eyeTex) {
            return this.eyesTexture(new ResourceLocation(eyeTex));
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        private Builder vanillaOverlayTexture(String ovrTex) {
            return this.overlayTexture(new ResourceLocation(ovrTex));
        }

        @Deprecated(since="3.1.14", forRemoval=true)
        private Builder vanillaAnimationTexture(String aniTex) {
            return this.animationTexture(new ResourceLocation(aniTex));
        }

        public Builder uniqueTexturesAll() {
            return this.uniqueBaseTexture().uniqueEyesTexture().uniqueOverlayTexture();
        }

        public Builder uniqueTextureWithEyes() {
            return this.uniqueBaseTexture().uniqueEyesTexture().noOverlayTexture();
        }

        public Builder uniqueTextureWithOverlay() {
            return this.uniqueBaseTexture().noEyesTexture().uniqueOverlayTexture();
        }

        public Builder uniqueTextureWithAnimation() {
            return this.uniqueBaseTexture().noEyesTexture().uniqueAnimationTexture();
        }

        public Builder uniqueTextureBaseOnly() {
            return this.uniqueBaseTexture().noEyesTexture().noOverlayTexture();
        }

        private Builder uniqueBaseTexture() {
            return this.baseTexture(this.getBaseTexture());
        }

        public Builder uniqueEyesTexture() {
            return this.eyesTexture(this.getEyesTexture());
        }

        public Builder uniqueOverlayTexture() {
            return this.overlayTexture(this.getOverlayTexture());
        }

        public Builder uniqueAnimationTexture() {
            return this.animationTexture(this.getAnimationTexture());
        }

        private ResourceLocation getBaseTexture() {
            return this.toTexture("");
        }

        private ResourceLocation getEyesTexture() {
            return this.toTexture("_eyes");
        }

        private ResourceLocation getOverlayTexture() {
            return this.toTexture("_overlay");
        }

        private ResourceLocation getAnimationTexture() {
            return this.toTexture("_anim");
        }

        private ResourceLocation toTexture(String suffix) {
            return References.getEntityTexture(ConfigUtil.camelCaseToLowerUnderscore((String)this.owningSpecies.family.name), ConfigUtil.camelCaseToLowerUnderscore((String)this.owningSpecies.specialVariantName), suffix);
        }

        public Builder noEyesTexture() {
            return this.eyesTexture(null);
        }

        public Builder noOverlayTexture() {
            return this.overlayTexture(null);
        }

        public Builder noAnimationTexture() {
            return this.animationTexture(null);
        }

        public Builder modBaseTexture(@Nonnull String tex) {
            this.texture = SpecialMobs.resourceLoc(tex);
            return this;
        }

        public Builder modEyesTexture(@Nonnull String eyesTex) {
            this.eyesTexture = SpecialMobs.resourceLoc(eyesTex);
            return this;
        }

        public Builder modOverlayTexture(@Nonnull String ovrTex) {
            this.overlayTexture = SpecialMobs.resourceLoc(ovrTex);
            return this;
        }

        public Builder modAnimationTexture(@Nonnull String aniTex) {
            this.animationTexture = SpecialMobs.resourceLoc(aniTex);
            return this;
        }

        private Builder baseTexture(@Nullable ResourceLocation tex) {
            this.texture = tex;
            return this;
        }

        private Builder eyesTexture(@Nullable ResourceLocation eyeTex) {
            this.eyesTexture = eyeTex;
            return this;
        }

        private Builder overlayTexture(@Nullable ResourceLocation ovrTex) {
            this.overlayTexture = ovrTex;
            return this;
        }

        private Builder animationTexture(@Nullable ResourceLocation aniTex) {
            this.animationTexture = aniTex;
            return this;
        }

        public Builder undead() {
            return this.drownImmune().effectImmune(MobEffects.f_19605_, MobEffects.f_19614_);
        }

        public Builder spider() {
            return this.webImmune().effectImmune(MobEffects.f_19614_);
        }

        public Builder experience(int xp) {
            this.experience = xp;
            return this;
        }

        public Builder addExperience(int xp) {
            return this.experience(this.experience + xp);
        }

        public Builder regen(int time) {
            this.healTime = time;
            return this;
        }

        public Builder fallImmune() {
            return this.fallDamage(0.0);
        }

        public Builder fallDamage(double multiplier) {
            this.fallDamageMultiplier = multiplier;
            return this;
        }

        public Builder fireImmune() {
            this.entityTypeBuilder.m_20719_();
            this.isImmuneToFire = true;
            return this;
        }

        public Builder burnImmune() {
            this.isImmuneToBurning = true;
            return this;
        }

        public Builder drownImmune() {
            this.canBreatheInWater = true;
            return this;
        }

        public Builder fluidPushImmune() {
            this.ignoreWaterPush = true;
            return this;
        }

        public Builder waterSensitive() {
            this.isDamagedByWater = true;
            return this;
        }

        public Builder waterInsensitive() {
            this.isDamagedByWater = false;
            return this;
        }

        public Builder leashable() {
            this.allowLeashing = true;
            return this;
        }

        public Builder pressurePlateImmune() {
            this.ignorePressurePlates = true;
            return this;
        }

        public Builder hazardImmune(Block ... hazards) {
            this.entityTypeBuilder.m_20714_(hazards);
            return this;
        }

        public Builder webImmune() {
            return this.stickyBlockImmune(Blocks.f_50033_);
        }

        public Builder stickyBlockImmune(Block ... blocks) {
            this.immuneToStickyBlocks.addAll(Arrays.asList(blocks));
            return this;
        }

        public Builder effectImmune(Object ... effects) {
            this.immuneToPotions.addAll(Arrays.asList(effects));
            return this;
        }

        public Builder bowAttack(double damage, double spread, double walkSpeed, int cooldown, double range) {
            return this.rangedDamage(damage).rangedSpread(spread).rangedWalkSpeed(walkSpeed).rangedCooldown(cooldown).rangedMaxRange(range);
        }

        public Builder throwAttack(double spread, double walkSpeed, int cooldown, double range) {
            return this.rangedSpread(spread).rangedWalkSpeed(walkSpeed).rangedCooldown(cooldown).rangedMaxRange(range);
        }

        public Builder fireballAttack(double spread, int charge, int cooldown, double range) {
            return this.rangedSpread(spread).rangedCooldown(charge).rangedMaxCooldown(charge + cooldown).rangedMaxRange(range);
        }

        public Builder spitAttack(double damage, double spread, int cooldown, int extraCooldown, double range) {
            return this.rangedDamage(damage).rangedSpread(spread).rangedCooldown(cooldown).rangedMaxCooldown(cooldown + extraCooldown).rangedMaxRange(range);
        }

        public Builder spitAttackMultiplied(double damage, double spread, float cooldown, double range) {
            return this.multiplyRangedDamage(damage).multiplyRangedSpread(spread).multiplyRangedCooldown(cooldown).multiplyRangedMaxCooldown(cooldown).multiplyRangedMaxRange(range);
        }

        public Builder convertRangedAttackToFishing(double spread, int cooldown, double range) {
            return this.setAllRangedStats(-1.0, spread, -1.0, cooldown, -1, range);
        }

        public Builder convertRangedAttackToBeam(double damage, double turnSpeed, int charge, int duration, double range) {
            return this.setAllRangedStats(damage, -1.0, turnSpeed, charge, charge + duration, range);
        }

        public Builder disableRangedAttack() {
            return this.rangedMaxRange(0.0);
        }

        public Builder addToRangedDamage(double value) {
            return this.rangedDamage(this.rangedAttackDamage + value);
        }

        public Builder multiplyRangedDamage(double value) {
            return this.rangedDamage(this.rangedAttackDamage * value);
        }

        public Builder rangedDamage(double value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackDamage < 0.0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackDamage = value;
            return this;
        }

        public Builder multiplyRangedSpread(double value) {
            return this.rangedSpread(this.rangedAttackSpread * value);
        }

        public Builder rangedSpread(double value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackSpread < 0.0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackSpread = value;
            return this;
        }

        public Builder multiplyRangedWalkSpeed(double value) {
            return this.rangedWalkSpeed(this.rangedWalkSpeed * value);
        }

        public Builder rangedWalkSpeed(double value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedWalkSpeed < 0.0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedWalkSpeed = value;
            return this;
        }

        public Builder multiplyRangedCooldown(float value) {
            return this.rangedCooldown(Math.round((float)this.rangedAttackCooldown * value));
        }

        public Builder rangedCooldown(int value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackCooldown < 0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackCooldown = value;
            return this;
        }

        public Builder multiplyRangedMaxCooldown(float value) {
            return this.rangedCooldown(Math.round((float)this.rangedAttackMaxCooldown * value));
        }

        public Builder rangedMaxCooldown(int value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackMaxCooldown < 0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackMaxCooldown = value;
            return this;
        }

        public Builder multiplyRangedMaxRange(double value) {
            return this.rangedMaxRange(this.rangedAttackMaxRange * value);
        }

        public Builder rangedMaxRange(double value) {
            if (this.owningSpecies.specialVariantName != null && this.rangedAttackMaxRange < 0.0) {
                throw new IllegalStateException("Attempted to add inapplicable ranged attack stat!");
            }
            this.rangedAttackMaxRange = value;
            return this;
        }

        private Builder setAllRangedStats(double damage, double spread, double walkSpeed, int cooldown, int maxCooldown, double range) {
            this.rangedAttackDamage = damage;
            this.rangedAttackSpread = spread;
            this.rangedWalkSpeed = walkSpeed;
            this.rangedAttackCooldown = cooldown;
            this.rangedAttackMaxCooldown = maxCooldown;
            this.rangedAttackMaxRange = range;
            return this;
        }

        public Builder addToAttribute(Attribute attribute, double value) {
            if (attribute == Attributes.f_22279_) {
                throw new IllegalArgumentException("Do not add flat movement speed!");
            }
            this.attributes.add(AttributeEntry.add((Attribute)attribute, (double)value));
            return this;
        }

        public Builder multiplyAttribute(Attribute attribute, double value) {
            this.attributes.add(AttributeEntry.mult((Attribute)attribute, (double)value));
            return this;
        }
    }

    public static enum DefaultWeight {
        DEFAULT(60.0),
        DISABLED(0.0),
        LOWEST(DefaultWeight.DEFAULT.value / 8.0),
        LOW(DefaultWeight.DEFAULT.value / 4.0),
        HIGH(DefaultWeight.DEFAULT.value * 2.5),
        HIGHEST(DefaultWeight.DEFAULT.value * 5.0);

        public final double value;

        private DefaultWeight(double v) {
            this.value = v;
        }
    }

    public static enum Theme {
        NONE(cfgManager -> new EnvironmentList(new EnvironmentEntry[0])),
        FIRE(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inUltraWarmDimension().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).isHot().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).isWarm().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).isFreezing().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inBiome(Biomes.f_48166_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).inBiome(Biomes.f_48167_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).inBiome(Biomes.f_48170_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOW.value).inBiome(Biomes.f_48168_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOW.value).inBiome(Biomes.f_48171_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).inBiome(Biomes.f_48172_).build()})),
        ICE(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).inUltraWarmDimension().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).isFreezing().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOW.value).isWarm().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).isHot().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inBiome(Biomes.f_48172_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).inBiome(Biomes.f_48168_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).inBiome(Biomes.f_48171_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOW.value).inBiome(Biomes.f_48167_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOW.value).inBiome(Biomes.f_48170_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).inBiome(Biomes.f_48166_).build()})),
        DESERT(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inUltraWarmDimension().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inNaturalDimension().inDryBiome().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).inWaterBiome().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).inHumidBiome().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).isRaining().canSeeSky().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).belowHalfMoonLight().build()})),
        WATER(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).inUltraWarmDimension().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOWEST.value).inNaturalDimension().inDryBiome().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inWaterBiome().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inHumidBiome().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).isRaining().canSeeSky().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).aboveHalfMoonLight().build()})),
        FOREST(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inBiomeCategory(BiomeCategory.TAIGA).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inBiomeCategory(BiomeCategory.JUNGLE).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inBiomeCategory(BiomeCategory.FOREST).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inBiome(Biomes.f_48200_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).atMaxMoonLight().build()})),
        MOUNTAIN(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inMountainBiome().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).aboveMountainLevel().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).atNoMoonLight().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOW.value).belowSeaLevel().build()})),
        STORM(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).isThundering().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).isRaining().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.LOW.value).cannotSeeSky().build()})),
        TROPICAL(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inBiome(Biomes.f_48166_).build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.DISABLED.value).isFreezing().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.DISABLED.value).inBiome(Biomes.f_48172_).build()})),
        FISHING(cfgManager -> new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGHEST.value).inWaterBiome().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).atMaxMoonLight().build(), EnvironmentEntry.builder((ConfigManager)cfgManager, (double)DefaultWeight.HIGH.value).isRaining().notInDryBiome().build()}));

        private final Function<ConfigManager, EnvironmentList> func;
        private EnvironmentList value;

        private Theme(Function<ConfigManager, EnvironmentList> func) {
            this.func = func;
        }

        public EnvironmentList getValue() {
            if (this.value == null) {
                this.value = this.func.apply(Config.MANAGER);
                this.value.setRange(DoubleField.Range.NON_NEGATIVE);
            }
            return this.value;
        }
    }
}

