/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;

public class CorporealShiftGhastSpeciesConfig
extends SpeciesConfig {
    public final CorporealShift CORPOREAL_SHIFT;

    public CorporealShiftGhastSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, int corporealTime, int incorporealTime) {
        super(manager, species);
        this.CORPOREAL_SHIFT = new CorporealShift(this, species, species.getConfigName(), corporealTime, incorporealTime);
    }

    public static class CorporealShift
    extends AbstractConfigCategory<CorporealShiftGhastSpeciesConfig> {
        public final IntField corporealTicks;
        public final IntField incorporealTicks;

        CorporealShift(CorporealShiftGhastSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, int corporealTime, int incorporealTime) {
            super((AbstractConfigFile)parent, ConfigUtil.camelCaseToLowerUnderscore((String)species.specialVariantName), new String[]{"Options specific to " + speciesName + "."});
            this.corporealTicks = (IntField)this.SPEC.define((AbstractConfigField)new IntField("ticks.corporeal", corporealTime, IntField.Range.NON_NEGATIVE, new String[]{"The number of ticks " + speciesName + " stay in 'corporeal' mode before shifting (20 ticks = 1 second).", "In corporeal mode, " + speciesName + " can be damaged and shoot like normal " + species.family.configName + "."}));
            this.incorporealTicks = (IntField)this.SPEC.define((AbstractConfigField)new IntField("ticks.incorporeal", incorporealTime, IntField.Range.NON_NEGATIVE, new String[]{"The number of ticks " + speciesName + " stay in 'incorporeal' mode before shifting (20 ticks = 1 second).", "In incorporeal mode, " + speciesName + " are immune to damage and shoot unique fireballs that punish movement."}));
        }
    }
}

