/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.BooleanField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;

public class CreeperSpeciesConfig
extends SpeciesConfig {
    public final Creepers CREEPERS;

    public CreeperSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, boolean cannotExplodeWhileWet, boolean explodeWhileBurning, boolean explodeWhenShot) {
        super(manager, species);
        this.CREEPERS = new Creepers(this, species, species.getConfigName(), cannotExplodeWhileWet, explodeWhileBurning, explodeWhenShot);
    }

    public static class Creepers
    extends AbstractConfigCategory<CreeperSpeciesConfig> {
        public final DoubleField stormChargeChance;
        public final BooleanField canExplodeWhileWet;
        public final BooleanField explodesWhileBurning;
        public final BooleanField explodesWhenShot;

        Creepers(CreeperSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, boolean cannotExplodeWhileWet, boolean explodeWhileBurning, boolean explodeWhenShot) {
            super((AbstractConfigFile)parent, ConfigUtil.noSpaces((String)species.family.configName), new String[]{"Options standard to all " + species.family.configName + "."});
            this.stormChargeChance = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("storm_charge_chance", -1.0, DoubleField.Range.SIGNED_PERCENT, new String[]{"Chance for " + speciesName + " to spawn charged during thunderstorms. If this is set to a non-negative value, it overrides the value set for \"family_storm_charge_chance\"."}));
            this.SPEC.newLine();
            this.canExplodeWhileWet = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("can_explode_while_wet", !cannotExplodeWhileWet, new String[]{"If true, " + speciesName + " can explode while wet (normal creeper behavior)."}));
            this.explodesWhileBurning = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("explodes_while_burning", explodeWhileBurning, new String[]{"If true, " + speciesName + " will explode while burning. If extinguished before the fuse runs out, they will resume normal behavior."}));
            this.explodesWhenShot = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("explodes_when_shot", explodeWhenShot, new String[]{"If true, " + speciesName + " will explode when hit by an indirect attack (e.g. an arrow)."}));
        }
    }
}

