/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;

public class DrownedSpeciesConfig
extends SpeciesConfig {
    public final Drowned DROWNED;

    public DrownedSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, double tridentChance, double shieldChance) {
        super(manager, species);
        this.DROWNED = new Drowned(this, species, species.getConfigName(), tridentChance, shieldChance);
    }

    public static class Drowned
    extends AbstractConfigCategory<DrownedSpeciesConfig> {
        public final DoubleField tridentEquipChance;
        public final DoubleField shieldEquipChance;

        Drowned(DrownedSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, double tridentChance, double shieldChance) {
            super((AbstractConfigFile)parent, ConfigUtil.noSpaces((String)species.family.configName), new String[]{"Options standard to all " + species.family.configName + "."});
            double effectiveDefault = species.bestiaryInfo.rangedAttackMaxRange > 0.0 ? tridentChance : 0.0;
            this.tridentEquipChance = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("trident_chance", effectiveDefault, DoubleField.Range.PERCENT, new String[]{"Chance for " + speciesName + " to spawn with a trident, which enables their ranged attack (if max range > 0)."}));
            this.SPEC.newLine();
            this.shieldEquipChance = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("shield_chance", shieldChance, DoubleField.Range.PERCENT, new String[]{"Chance for " + speciesName + " to spawn with a shield.", "Shield users have a 33% chance to block frontal attacks (100% vs. long range attacks) and can be broken by axes."}));
        }
    }
}

