/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.species.SpiderSpeciesConfig;

public class MotherSpiderSpeciesConfig
extends SpiderSpeciesConfig {
    public final Mother MOTHER;

    public MotherSpiderSpeciesConfig(ConfigManager manager, MobFamily.Species<?> species, double spitChance, int minBabies, int maxBabies, int minExtraBabies, int maxExtraBabies) {
        super(manager, species, spitChance);
        this.MOTHER = new Mother(this, species, species.getConfigName(), minBabies, maxBabies, minExtraBabies, maxExtraBabies);
    }

    public static class Mother
    extends AbstractConfigCategory<MotherSpiderSpeciesConfig> {
        public final IntField.RandomRange babies;
        public final IntField.RandomRange extraBabies;

        Mother(MotherSpiderSpeciesConfig parent, MobFamily.Species<?> species, String speciesName, int minBabies, int maxBabies, int minExtraBabies, int maxExtraBabies) {
            super((AbstractConfigFile)parent, ConfigUtil.camelCaseToLowerUnderscore((String)species.specialVariantName), new String[]{"Options specific to " + speciesName + "."});
            this.babies = new IntField.RandomRange((IntField)this.SPEC.define((AbstractConfigField)new IntField("babies.min", minBabies, IntField.Range.NON_NEGATIVE, new String[]{"The minimum and maximum (inclusive) number of babies " + speciesName + " spawn on death.", "Any remaining 'extra babies' will added to the amount spawned on death (see below)."})), (IntField)this.SPEC.define((AbstractConfigField)new IntField("babies.max", maxBabies, IntField.Range.NON_NEGATIVE, new String[0])));
            this.SPEC.newLine();
            this.extraBabies = new IntField.RandomRange((IntField)this.SPEC.define((AbstractConfigField)new IntField("extra_babies.min", minExtraBabies, IntField.Range.NON_NEGATIVE, new String[]{"The minimum and maximum (inclusive) number of babies that " + speciesName + " can spawn from hits before death.", "Any remaining 'extra babies' will added to the amount spawned on death (see above)."})), (IntField)this.SPEC.define((AbstractConfigField)new IntField("extra_babies.max", maxExtraBabies, IntField.Range.NON_NEGATIVE, new String[0])));
        }
    }
}

