/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.config.species;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.AttributeListField;
import fathertoast.crust.api.config.common.field.BooleanField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.EnvironmentListField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.config.common.field.LazyRegistryEntryListField;
import fathertoast.crust.api.config.common.field.RegistryEntryListField;
import fathertoast.crust.api.config.common.value.EnvironmentEntry;
import fathertoast.crust.api.config.common.value.EnvironmentList;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.family.FamilyConfig;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.Block;

public class SpeciesConfig
extends AbstractConfigFile {
    public static final String SPECIAL_DATA_SUBCAT = "special_data.";
    public static EnvironmentList NEXT_NATURAL_SPAWN_CHANCE_EXCEPTIONS;
    public final General GENERAL;

    protected static String fileName(MobFamily.Species<?> species) {
        return (species.specialVariantName == null ? "_normal" : ConfigUtil.camelCaseToLowerUnderscore((String)species.specialVariantName)) + "_" + ConfigUtil.noSpaces((String)species.family.configName);
    }

    public SpeciesConfig(ConfigManager manager, MobFamily.Species<?> species) {
        super(manager, FamilyConfig.dir(species.family) + "/" + SpeciesConfig.fileName(species), new String[]{"This config contains options that apply only to the " + species.getConfigNameSingular() + " species."});
        this.GENERAL = new General(this, species, species.getConfigName());
    }

    public static class General
    extends AbstractConfigCategory<SpeciesConfig> {
        public final DoubleField.EnvironmentSensitive naturalSpawnChance;
        public final DoubleField randomScaling;
        public final AttributeListField attributeChanges;
        public final IntField experience;
        public final IntField healTime;
        public final DoubleField fallDamageMultiplier;
        public final BooleanField isImmuneToFire;
        public final BooleanField isImmuneToBurning;
        public final BooleanField canBreatheInWater;
        public final BooleanField ignoreWaterPush;
        public final BooleanField isDamagedByWater;
        public final BooleanField allowLeashing;
        public final BooleanField ignorePressurePlates;
        public final RegistryEntryListField<Block> immuneToStickyBlocks;
        public final RegistryEntryListField<MobEffect> immuneToPotions;
        public final DoubleField rangedAttackDamage;
        public final DoubleField rangedAttackSpread;
        public final DoubleField rangedWalkSpeed;
        public final IntField rangedAttackCooldown;
        public final IntField rangedAttackMaxCooldown;
        public final DoubleField rangedAttackMaxRange;

        General(SpeciesConfig parent, MobFamily.Species<?> species, String speciesName) {
            super((AbstractConfigFile)parent, "general", new String[]{"Options standard to all mob species (that is, not specific to any particular mob species)."});
            BestiaryInfo info = species.bestiaryInfo;
            this.naturalSpawnChance = new DoubleField.EnvironmentSensitive((DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("natural_spawn_chance.base", 1.0, DoubleField.Range.PERCENT, new String[]{"The chance for " + speciesName + " to succeed at natural spawn attempts. Does not affect Mob Replacement.", "Note: Most species do NOT naturally spawn - they must be added by a mod or data pack for this option to do anything."})), (EnvironmentListField)this.SPEC.define((AbstractConfigField)new EnvironmentListField("natural_spawn_chance.exceptions", General.getDefaultSpawnExceptions().setRange(DoubleField.Range.PERCENT), new String[]{"The chance for " + speciesName + " to succeed at natural spawn attempts when specific environmental conditions are met."})));
            this.SPEC.newLine();
            this.randomScaling = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("random_scaling", -1.0, DoubleField.Range.SIGNED_PERCENT, new String[]{"When greater than 0, " + speciesName + " will have a random render scale applied. This is a visual effect only. If this is set to a non-negative value, it overrides the value set for both \"master_random_scaling\" and \"family_random_scaling\". The priority is species value > family value > master value."}));
            this.SPEC.newLine();
            this.attributeChanges = (AttributeListField)this.SPEC.define((AbstractConfigField)new AttributeListField("attributes", info.defaultAttributes, new String[]{"Attribute modifiers for " + speciesName + ". If no attribute changes are defined here, " + speciesName + " will have the exact same attributes as their parent vanilla mob."}));
            this.SPEC.increaseIndent();
            this.SPEC.subcategory(SpeciesConfig.SPECIAL_DATA_SUBCAT.substring(0, SpeciesConfig.SPECIAL_DATA_SUBCAT.length() - 1), new String[]{"Special Mob Data. These are the values set to each " + species.getConfigNameSingular() + " on spawn (in their NBT)."});
            this.experience = (IntField)this.SPEC.define((AbstractConfigField)new IntField("special_data.experience", info.experience, IntField.Range.NON_NEGATIVE, new String[]{"The amount of experience " + speciesName + " drop when killed by a player. Multiplied by 2.5 for babies. Extra experience may drop based on equipment. Slime-style mobs also drop experience equal to slime size."}));
            this.healTime = (IntField)this.SPEC.define((AbstractConfigField)new IntField("special_data.heal_time", info.healTime, IntField.Range.NON_NEGATIVE, new String[]{"If greater than 0, " + speciesName + " will heal 1 half-heart of health every \"heal_time\" ticks. (20 ticks = 1 second)"}));
            this.fallDamageMultiplier = (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("special_data.fall_damage_multiplier", info.fallDamageMultiplier, DoubleField.Range.NON_NEGATIVE, new String[]{"Fall damage taken by " + speciesName + " is multiplied by this value. 0 is fall damage immunity."}));
            this.isImmuneToFire = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("special_data.immune_to_fire", info.isImmuneToFire, new String[]{"If true, " + speciesName + " will take no fire damage. Does not affect spawn restrictions."}));
            this.isImmuneToBurning = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("special_data.immune_to_burning", info.isImmuneToBurning, new String[]{"If true, " + speciesName + " cannot be set on fire (this setting only matters if not immune to fire)."}));
            this.canBreatheInWater = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("special_data.immune_to_drowning", info.canBreatheInWater, new String[]{"If true, " + speciesName + " can breathe in water."}));
            this.ignoreWaterPush = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("special_data.immune_to_fluid_push", info.ignoreWaterPush, new String[]{"If true, " + speciesName + " will ignore forces applied by flowing fluids."}));
            this.isDamagedByWater = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("special_data.sensitive_to_water", info.isDamagedByWater, new String[]{"If true, " + speciesName + " will be continuously damaged while wet."}));
            this.allowLeashing = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("special_data.allow_leashing", info.allowLeashing, new String[]{"If true, " + speciesName + " can be leashed. (Note: Leashed mobs can still attack you.)"}));
            this.ignorePressurePlates = (BooleanField)this.SPEC.define((AbstractConfigField)new BooleanField("special_data.immune_to_pressure_plates", info.ignorePressurePlates, new String[]{"If true, " + speciesName + " will not trigger pressure plates."}));
            this.immuneToStickyBlocks = (RegistryEntryListField)this.SPEC.define((AbstractConfigField)new LazyRegistryEntryListField("special_data.immune_to_sticky_blocks", info.immuneToStickyBlocks, new String[]{ConfigUtil.properCase((String)speciesName) + " will not be 'trapped' in any blocks specified here (e.g. \"cobweb\" or \"sweet_berry_bush\")."}));
            this.immuneToPotions = (RegistryEntryListField)this.SPEC.define((AbstractConfigField)new LazyRegistryEntryListField("special_data.immune_to_effects", info.immuneToPotions, new String[]{ConfigUtil.properCase((String)speciesName) + " cannot be inflicted with any effects specified here (e.g. \"instant_damage\" or \"regeneration\")."}));
            if (General.hasNoRangedStats(info)) {
                this.SPEC.decreaseIndent();
                this.rangedAttackMaxRange = null;
                this.rangedWalkSpeed = null;
                this.rangedAttackSpread = null;
                this.rangedAttackDamage = null;
                this.rangedAttackMaxCooldown = null;
                this.rangedAttackCooldown = null;
                return;
            }
            this.SPEC.subcategory("ranged_stats", new String[]{"Like Special Mob Data, these are set to NBT on spawn. Unlike SMD, ranged stats are not all applicable to all mobs."});
            this.rangedAttackDamage = info.rangedAttackDamage < 0.0 ? null : (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("special_data.ranged_attack.damage", info.rangedAttackDamage, DoubleField.Range.NON_NEGATIVE, new String[]{"The base ranged attack damage for " + speciesName + " (in half-hearts)."}));
            this.rangedAttackSpread = info.rangedAttackSpread < 0.0 ? null : (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("special_data.ranged_attack.spread", info.rangedAttackSpread, DoubleField.Range.NON_NEGATIVE, new String[]{"The ranged attack spread (inaccuracy) for " + speciesName + ". 0 is perfect accuracy."}));
            this.rangedWalkSpeed = info.rangedWalkSpeed < 0.0 ? null : (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("special_data.ranged_attack.walk_speed", info.rangedWalkSpeed, DoubleField.Range.NON_NEGATIVE, new String[]{"The walk speed multiplier for " + speciesName + " while using their ranged attack AI."}));
            this.rangedAttackCooldown = info.rangedAttackCooldown < 0 ? null : (IntField)this.SPEC.define((AbstractConfigField)new IntField("special_data.ranged_attack.charge_time", info.rangedAttackCooldown, IntField.Range.NON_NEGATIVE, new String[]{"The delay (in ticks) for " + speciesName + " to perform a ranged attack from rest. (20 ticks = 1 second)"}));
            this.rangedAttackMaxCooldown = info.rangedAttackMaxCooldown < 0 ? null : (IntField)this.SPEC.define((AbstractConfigField)new IntField("special_data.ranged_attack.refire_time", info.rangedAttackMaxCooldown, IntField.Range.NON_NEGATIVE, new String[]{"The total delay (in ticks) " + speciesName + " wait between each ranged attack. (20 ticks = 1 second)"}));
            this.rangedAttackMaxRange = info.rangedAttackMaxRange < 0.0 ? null : (DoubleField)this.SPEC.define((AbstractConfigField)new DoubleField("special_data.ranged_attack.max_range", info.rangedAttackMaxRange, DoubleField.Range.NON_NEGATIVE, new String[]{"The maximum distance (in blocks) at which " + speciesName + " can use their ranged attacks. 0 disables ranged attacks."}));
            this.SPEC.decreaseIndent();
        }

        private static boolean hasNoRangedStats(BestiaryInfo info) {
            return info.rangedAttackDamage < 0.0 && info.rangedAttackSpread < 0.0 && info.rangedWalkSpeed < 0.0 && info.rangedAttackCooldown < 0 && info.rangedAttackMaxCooldown < 0 && info.rangedAttackMaxRange < 0.0;
        }

        private static EnvironmentList getDefaultSpawnExceptions() {
            if (NEXT_NATURAL_SPAWN_CHANCE_EXCEPTIONS == null) {
                return new EnvironmentList(new EnvironmentEntry[0]);
            }
            EnvironmentList presetValue = NEXT_NATURAL_SPAWN_CHANCE_EXCEPTIONS;
            NEXT_NATURAL_SPAWN_CHANCE_EXCEPTIONS = null;
            return presetValue;
        }
    }
}

