/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.core;

import fathertoast.crust.api.lib.EnvironmentHelper;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.family.FamilyConfig;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.MobHelper;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="specialmobs", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class SpecialMobReplacer {
    private static final Deque<MobReplacementEntry> TO_REPLACE = new ArrayDeque<MobReplacementEntry>();
    private static final List<DelayedMobReplacementEntry> DELAYED_REPLACE = new ArrayList<DelayedMobReplacementEntry>();
    private static final Predicate<MobFamily.Species<?>> WATER_INSENSITIVE_SELECTOR = species -> !species.config.GENERAL.isDamagedByWater.get();
    private static final Predicate<MobFamily.Species<?>> NO_GIANTS_SELECTOR = MobFamily.Species::isNotGiant;

    @SubscribeEvent
    public static void onMobSpawn(MobSpawnEvent.FinalizeSpawn event) {
        MobSpawnType spawnType = event.getSpawnType();
        if (spawnType == MobSpawnType.CHUNK_GENERATION || spawnType == MobSpawnType.STRUCTURE) {
            SpecialMobReplacer.setInitFlag((Entity)event.getEntity());
            return;
        }
        if (spawnType == MobSpawnType.SPAWNER && Config.MAIN.GENERAL.skipSpawnerSpawns.get()) {
            SpecialMobReplacer.setInitFlag((Entity)event.getEntity());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        if (event.getLevel().m_5776_() || event.loadedFromDisk() || !Config.MAIN.GENERAL.enableMobReplacement.get()) {
            return;
        }
        Entity entity = event.getEntity();
        MobFamily<?, ?> mobFamily = SpecialMobReplacer.getReplacingMobFamily(entity);
        if (mobFamily != null) {
            Level level = event.getLevel();
            BlockPos entityPos = BlockPos.m_274446_((Position)entity.m_20182_());
            SpecialMobReplacer.setInitFlag(entity);
            if (level.m_46749_(BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20186_(), (double)entity.m_20189_()))) {
                boolean isSpecial = SpecialMobReplacer.shouldMakeNextSpecial(mobFamily, level, entityPos);
                if (SpecialMobReplacer.shouldReplace(mobFamily, isSpecial)) {
                    TO_REPLACE.addLast(new MobReplacementEntry(mobFamily, isSpecial, entity, level, entityPos));
                    event.setCanceled(true);
                }
            } else {
                DELAYED_REPLACE.add(new DelayedMobReplacementEntry(mobFamily, entity, level, entityPos));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (!DELAYED_REPLACE.isEmpty()) {
                DELAYED_REPLACE.removeIf(DelayedMobReplacementEntry::update);
            }
            while (!TO_REPLACE.isEmpty()) {
                MobReplacementEntry replacement = TO_REPLACE.removeFirst();
                SpecialMobReplacer.replace(replacement.mobFamily, replacement.isSpecial, (Entity)replacement.entityToReplace, replacement.entityWorld, replacement.entityPos);
            }
        }
    }

    private static boolean getInitFlag(Entity entity) {
        CompoundTag forgeData = entity.getPersistentData();
        if (forgeData.m_128425_("SpecialMobsInit", 99)) {
            return forgeData.m_128471_("SpecialMobsInit");
        }
        return false;
    }

    private static void setInitFlag(Entity entity) {
        CompoundTag forgeData = entity.getPersistentData();
        forgeData.m_128379_("SpecialMobsInit", true);
    }

    @Nullable
    private static MobFamily<?, ?> getReplacingMobFamily(@Nullable Entity entity) {
        if (entity == null || SpecialMobReplacer.getInitFlag(entity)) {
            return null;
        }
        return MobFamily.getReplacementFamily(entity);
    }

    private static boolean shouldMakeNextSpecial(MobFamily<?, ?> mobFamily, Level level, BlockPos entityPos) {
        return level.f_46441_.m_188500_() < ((FamilyConfig)((Object)mobFamily.config)).GENERAL.specialVariantChance.get(level, entityPos);
    }

    private static boolean shouldReplace(MobFamily<?, ?> mobFamily, boolean isSpecial) {
        return isSpecial || Config.MAIN.GENERAL.masterVanillaReplacement.get() && ((FamilyConfig)((Object)mobFamily.config)).GENERAL.vanillaReplacement.get();
    }

    private static void replace(MobFamily<?, ?> mobFamily, boolean isSpecial, Entity entityToReplace, Level level, BlockPos entityPos) {
        if (!(level instanceof ServerLevelAccessor) || !EnvironmentHelper.isLoaded((LevelAccessor)level, (BlockPos)entityPos)) {
            return;
        }
        CompoundTag tag = new CompoundTag();
        entityToReplace.m_20240_(tag);
        tag.m_128473_("UUID");
        MobFamily.Species species = isSpecial ? mobFamily.nextVariant(level, entityPos, SpecialMobReplacer.getVariantFilter(mobFamily, entityToReplace, level, entityPos)) : mobFamily.vanillaReplacement;
        LivingEntity replacement = (LivingEntity)((EntityType)species.entityType.get()).m_20615_(level);
        if (replacement == null) {
            SpecialMobs.LOG.error("Failed to create replacement entity '{}'", (Object)species.entityType.getId());
            return;
        }
        replacement.m_20258_(tag);
        replacement.m_21153_((float)replacement.m_21133_(Attributes.f_22276_));
        MobHelper.finalizeSpawn(replacement, (ServerLevelAccessor)level, level.m_6436_(entityPos), null, null);
        level.m_7967_((Entity)replacement);
        for (Entity rider : entityToReplace.m_20197_()) {
            rider.m_8127_();
            rider.m_7998_((Entity)replacement, true);
        }
        if (entityToReplace.m_20202_() != null) {
            Entity vehicle = entityToReplace.m_20202_();
            entityToReplace.m_8127_();
            replacement.m_7998_(vehicle, true);
        }
        entityToReplace.m_146870_();
    }

    @Nullable
    private static Predicate<MobFamily.Species<?>> getVariantFilter(MobFamily<?, ?> mobFamily, Entity entityToReplace, Level level, BlockPos entityPos) {
        Predicate<MobFamily.Species<?>> selector = null;
        if (!mobFamily.vanillaReplacement.bestiaryInfo.isDamagedByWater && level.m_46758_(entityPos)) {
            selector = WATER_INSENSITIVE_SELECTOR;
        }
        if (mobFamily.hasAnyGiants()) {
            AABB bb = entityToReplace.m_20191_();
            int y = Mth.m_14165_((double)bb.f_82292_);
            if (!level.m_5450_(entityToReplace, Shapes.m_83064_((AABB)new AABB(bb.f_82288_, (double)y, bb.f_82290_, bb.f_82291_, (double)(y + 1), bb.f_82293_)))) {
                selector = selector == null ? NO_GIANTS_SELECTOR : selector.and(NO_GIANTS_SELECTOR);
            }
        }
        return selector;
    }

    private static class MobReplacementEntry {
        final MobFamily<?, ?> mobFamily;
        final boolean isSpecial;
        final LivingEntity entityToReplace;
        final Level entityWorld;
        final BlockPos entityPos;

        MobReplacementEntry(MobFamily<?, ?> family, boolean special, Entity entity, Level level, BlockPos pos) {
            this.mobFamily = family;
            this.isSpecial = special;
            this.entityToReplace = (LivingEntity)entity;
            this.entityWorld = level;
            this.entityPos = pos;
        }
    }

    private static class DelayedMobReplacementEntry {
        final MobFamily<?, ?> mobFamily;
        final LivingEntity entityToReplace;
        final Level entityLevel;
        final BlockPos entityPos;
        int ticksRemaining = 6;

        DelayedMobReplacementEntry(MobFamily<?, ?> family, Entity entity, Level level, BlockPos pos) {
            this.mobFamily = family;
            this.entityToReplace = (LivingEntity)entity;
            this.entityLevel = level;
            this.entityPos = pos;
        }

        boolean update() {
            if (this.ticksRemaining > 0) {
                --this.ticksRemaining;
            } else {
                if (!this.entityToReplace.m_6084_()) {
                    return true;
                }
                if (this.entityLevel.m_46749_(this.entityPos)) {
                    boolean isSpecial = SpecialMobReplacer.shouldMakeNextSpecial(this.mobFamily, this.entityLevel, this.entityPos);
                    if (SpecialMobReplacer.shouldReplace(this.mobFamily, isSpecial)) {
                        TO_REPLACE.addLast(new MobReplacementEntry(this.mobFamily, isSpecial, (Entity)this.entityToReplace, this.entityLevel, this.entityPos));
                        this.entityToReplace.m_146870_();
                    }
                    return true;
                }
                this.ticksRemaining = 5;
            }
            return false;
        }
    }
}

