/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.core;

import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.core.register.SMBiomeMods;
import fathertoast.specialmobs.common.core.register.SMBlocks;
import fathertoast.specialmobs.common.core.register.SMCreativeTabs;
import fathertoast.specialmobs.common.core.register.SMEffects;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.event.AdvancementFixer;
import fathertoast.specialmobs.common.event.GameEvents;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.network.PacketHandler;
import fathertoast.specialmobs.common.util.SMDispenserBehavior;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="specialmobs")
public class SpecialMobs {
    public static final String MOD_ID = "specialmobs";
    public static final Logger LOG = LogManager.getLogger((String)"specialmobs");
    private final PacketHandler packetHandler = new PacketHandler();

    public SpecialMobs() {
        Config.initialize();
        this.packetHandler.registerMessages();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        SMBlocks.REGISTRY.register(modEventBus);
        SMItems.REGISTRY.register(modEventBus);
        SMCreativeTabs.REGISTRY.register(modEventBus);
        SMEntities.REGISTRY.register(modEventBus);
        SMEffects.REGISTRY.register(modEventBus);
        SMBiomeMods.REGISTRY.register(modEventBus);
        modEventBus.addListener(SMEntities::createAttributes);
        modEventBus.addListener(SMCreativeTabs::buildCreativeContents);
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::sendIMCMessages);
        modEventBus.addListener(NaturalSpawnManager::registerSpawnPlacements);
        MinecraftForge.EVENT_BUS.register((Object)new GameEvents());
        MinecraftForge.EVENT_BUS.register((Object)new AdvancementFixer());
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> SMDispenserBehavior.registerBehaviors());
    }

    public void sendIMCMessages(InterModEnqueueEvent event) {
    }

    public static ResourceLocation resourceLoc(String path) {
        return new ResourceLocation(MOD_ID, path);
    }

    public static <T> String toString(@Nullable T regEntry, IForgeRegistry<T> registry) {
        return regEntry == null || !registry.containsValue(regEntry) ? "null" : SpecialMobs.toString(registry.getKey(regEntry));
    }

    public static String toString(@Nullable ResourceLocation res) {
        return res == null ? "null" : res.toString();
    }
}

