/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity;

import fathertoast.crust.api.config.common.value.RegistryEntryList;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.config.Config;
import fathertoast.specialmobs.common.config.family.FamilyConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.util.References;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.registries.ForgeRegistries;

public class SpecialMobData<T extends Mob> {
    private final T theEntity;
    private final EntityDataAccessor<Float> renderScale;
    private int healTimeMax;
    private int healTime;
    private float fallDamageMultiplier;
    private boolean isImmuneToFire;
    private boolean isImmuneToBurning;
    private boolean canBreatheInWater;
    private boolean ignoreWaterPush;
    private boolean isDamagedByWater;
    private boolean allowLeashing;
    private boolean ignorePressurePlates;
    private final HashSet<Block> immuneToStickyBlocks = new HashSet();
    private final HashSet<MobEffect> immuneToPotions = new HashSet();
    private float rangedAttackDamage;
    private float rangedAttackSpread;
    private float rangedWalkSpeed;
    private int rangedAttackCooldown;
    private int rangedAttackMaxCooldown;
    private float rangedAttackMaxRange;

    public static CompoundTag getSaveLocation(CompoundTag tag) {
        CompoundTag forgeTag;
        if (!tag.m_128425_("ForgeData", References.NBT_TYPE_COMPOUND)) {
            tag.m_128365_("ForgeData", (Tag)new CompoundTag());
        }
        if (!(forgeTag = tag.m_128469_("ForgeData")).m_128425_("SpecialMobsData", References.NBT_TYPE_COMPOUND)) {
            forgeTag.m_128365_("SpecialMobsData", (Tag)new CompoundTag());
        }
        return forgeTag.m_128469_("SpecialMobsData");
    }

    public SpecialMobData(T entity, EntityDataAccessor<Float> scale) {
        this.theEntity = entity;
        this.renderScale = scale;
        entity.m_20088_().m_135372_(this.renderScale, (Object)Float.valueOf(this.nextScale()));
        SpeciesConfig.General config = ((ISpecialMob)this.theEntity).getSpecies().config.GENERAL;
        this.setRangedAttackDamage(config.rangedAttackDamage == null ? -1.0f : (float)config.rangedAttackDamage.get());
        this.setRangedAttackSpread(config.rangedAttackSpread == null ? -1.0f : (float)config.rangedAttackSpread.get());
        this.setRangedWalkSpeed(config.rangedWalkSpeed == null ? -1.0f : (float)config.rangedWalkSpeed.get());
        this.setRangedAttackCooldown(config.rangedAttackCooldown == null ? -1 : config.rangedAttackCooldown.get());
        this.setRangedAttackMaxCooldown(config.rangedAttackMaxCooldown == null ? -1 : config.rangedAttackMaxCooldown.get());
        this.setRangedAttackMaxRange(config.rangedAttackMaxRange == null ? -1.0f : (float)config.rangedAttackMaxRange.get());
    }

    public void initialize() {
        SpeciesConfig.General config = ((ISpecialMob)this.theEntity).getSpecies().config.GENERAL;
        ((ISpecialMob)this.theEntity).setExperience(config.experience.get());
        this.setRegenerationTime(config.healTime.get());
        this.setFallDamageMultiplier((float)config.fallDamageMultiplier.get());
        this.setImmuneToFire(config.isImmuneToFire.get());
        this.setImmuneToBurning(config.isImmuneToBurning.get());
        this.setCanBreatheInWater(config.canBreatheInWater.get());
        this.setIgnoreWaterPush(config.ignoreWaterPush.get());
        this.setDamagedByWater(config.isDamagedByWater.get());
        this.setAllowLeashing(config.allowLeashing.get());
        this.setIgnorePressurePlates(config.ignorePressurePlates.get());
        this.addStickyBlockImmunity(((RegistryEntryList)config.immuneToStickyBlocks.get()).getEntries());
        this.addPotionImmunity(((RegistryEntryList)config.immuneToPotions.get()).getEntries());
    }

    public void tick() {
        if (!this.theEntity.m_9236_().f_46443_ && this.theEntity.m_6084_() && this.healTimeMax > 0 && ++this.healTime >= this.healTimeMax) {
            this.healTime = 0;
            this.theEntity.m_5634_(1.0f);
        }
    }

    public ResourceLocation getTexture() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.texture;
    }

    @Nullable
    public ResourceLocation getTextureEyes() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.eyesTexture;
    }

    @Nullable
    public ResourceLocation getTextureOverlay() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.overlayTexture;
    }

    @Nullable
    public ResourceLocation getTextureAnimation() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.animationTexture;
    }

    public float getRenderScale() {
        return ((Float)this.theEntity.m_20088_().m_135370_(this.renderScale)).floatValue();
    }

    public void setRenderScale(float scale) {
        if (!this.theEntity.m_9236_().f_46443_) {
            this.theEntity.m_20088_().m_135381_(this.renderScale, (Object)Float.valueOf(scale));
        }
    }

    public float getHeightScale() {
        return ((ISpecialMob)this.theEntity).getSpecies().getHeightScale();
    }

    public float getHeightScaleByAge() {
        return this.getHeightScale() * (this.theEntity.m_6162_() ? 0.53448f : 1.0f);
    }

    private float getBaseScale() {
        return ((ISpecialMob)this.theEntity).getSpecies().bestiaryInfo.baseScale;
    }

    private float nextScale() {
        if (this.theEntity.m_9236_() == null || this.theEntity.m_9236_().m_5776_()) {
            return this.getBaseScale();
        }
        MobFamily.Species species = ((ISpecialMob)this.theEntity).getSpecies();
        double randomScaling = species.config.GENERAL.randomScaling.get() >= 0.0 ? species.config.GENERAL.randomScaling.get() : (((FamilyConfig)((Object)species.family.config)).GENERAL.familyRandomScaling.get() >= 0.0 ? ((FamilyConfig)((Object)species.family.config)).GENERAL.familyRandomScaling.get() : Config.MAIN.GENERAL.masterRandomScaling.get());
        return randomScaling <= 0.0 ? this.getBaseScale() : this.getBaseScale() * (1.0f + (this.theEntity.m_217043_().m_188501_() - 0.5f) * 2.0f * (float)randomScaling);
    }

    private void setRegenerationTime(int ticks) {
        this.healTimeMax = ticks;
    }

    public float getFallDamageMultiplier() {
        return this.fallDamageMultiplier;
    }

    private void setFallDamageMultiplier(float value) {
        this.fallDamageMultiplier = value;
    }

    public boolean isImmuneToFire() {
        return this.isImmuneToFire;
    }

    private void setImmuneToFire(boolean value) {
        this.isImmuneToFire = value;
        if (value) {
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.LAVA, BlockPathTypes.WATER.m_77124_());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.DANGER_FIRE, BlockPathTypes.OPEN.m_77124_());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.OPEN.m_77124_());
        } else {
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.LAVA, BlockPathTypes.LAVA.m_77124_());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.DANGER_FIRE, BlockPathTypes.DANGER_FIRE.m_77124_());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.DAMAGE_FIRE.m_77124_());
        }
    }

    public boolean isImmuneToBurning() {
        return this.isImmuneToBurning;
    }

    private void setImmuneToBurning(boolean value) {
        this.theEntity.m_20095_();
        this.isImmuneToBurning = value;
        if (value) {
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.OPEN.m_77124_());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.DANGER_FIRE.m_77124_());
        } else {
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.DANGER_FIRE, BlockPathTypes.DANGER_FIRE.m_77124_());
            ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.DAMAGE_FIRE, BlockPathTypes.DAMAGE_FIRE.m_77124_());
        }
    }

    public boolean allowLeashing() {
        return this.allowLeashing;
    }

    private void setAllowLeashing(boolean value) {
        this.allowLeashing = value;
    }

    public boolean ignorePressurePlates() {
        return this.ignorePressurePlates;
    }

    private void setIgnorePressurePlates(boolean value) {
        this.ignorePressurePlates = value;
    }

    public boolean canBreatheInWater() {
        return this.canBreatheInWater;
    }

    private void setCanBreatheInWater(boolean value) {
        this.canBreatheInWater = value;
    }

    public boolean ignoreWaterPush() {
        return this.ignoreWaterPush;
    }

    private void setIgnoreWaterPush(boolean value) {
        this.ignoreWaterPush = value;
    }

    public boolean isDamagedByWater() {
        return this.isDamagedByWater;
    }

    private void setDamagedByWater(boolean value) {
        this.isDamagedByWater = value;
        ((ISpecialMob)this.theEntity).setSpecialPathfindingMalus(BlockPathTypes.WATER, value ? BlockPathTypes.LAVA.m_77124_() : BlockPathTypes.WATER.m_77124_());
    }

    public boolean canBeStuckIn(@Nullable BlockState block) {
        return block != null && !this.immuneToStickyBlocks.contains(block.m_60734_());
    }

    private void addStickyBlockImmunity(Collection<Block> blocks) {
        this.immuneToStickyBlocks.addAll(blocks);
    }

    public boolean isPotionApplicable(MobEffectInstance effect) {
        MobEffectEvent.Applicable event = new MobEffectEvent.Applicable(this.theEntity, effect);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return switch (event.getResult()) {
            case Event.Result.DENY -> false;
            case Event.Result.ALLOW -> true;
            default -> !this.immuneToPotions.contains(effect.m_19544_());
        };
    }

    private void addPotionImmunity(Collection<MobEffect> effects) {
        this.immuneToPotions.addAll(effects);
    }

    public float getRangedAttackDamage() {
        return this.rangedAttackDamage;
    }

    public void setRangedAttackDamage(float value) {
        this.rangedAttackDamage = value;
    }

    public float getRangedAttackSpread() {
        return this.rangedAttackSpread;
    }

    public void setRangedAttackSpread(float value) {
        this.rangedAttackSpread = value;
    }

    public float getRangedWalkSpeed() {
        return this.rangedWalkSpeed;
    }

    public void setRangedWalkSpeed(float value) {
        this.rangedWalkSpeed = value;
    }

    public int getRangedAttackCooldown() {
        return this.rangedAttackCooldown;
    }

    public void setRangedAttackCooldown(int value) {
        this.rangedAttackCooldown = value;
    }

    public int getRangedAttackMaxCooldown() {
        return this.rangedAttackMaxCooldown;
    }

    public void setRangedAttackMaxCooldown(int value) {
        this.rangedAttackMaxCooldown = value;
    }

    public float getRangedAttackMaxRange() {
        return this.rangedAttackMaxRange;
    }

    public void setRangedAttackMaxRange(float value) {
        this.rangedAttackMaxRange = value;
    }

    public void disableRangedAttack() {
        this.setRangedAttackMaxRange(0.0f);
    }

    public void writeToNBT(CompoundTag tag) {
        tag.m_128350_("RenderScale", this.getRenderScale());
        tag.m_128405_("Experience", ((ISpecialMob)this.theEntity).getExperience());
        tag.m_128344_("Regeneration", (byte)this.healTimeMax);
        tag.m_128350_("FallMulti", this.getFallDamageMultiplier());
        tag.m_128379_("FireImmune", this.isImmuneToFire());
        tag.m_128379_("BurningImmune", this.isImmuneToBurning());
        tag.m_128379_("Leashable", this.allowLeashing());
        tag.m_128379_("UnderPressure", this.ignorePressurePlates());
        tag.m_128379_("DrownImmune", this.canBreatheInWater());
        tag.m_128379_("WaterPushImmune", this.ignoreWaterPush());
        tag.m_128379_("WaterDamage", this.isDamagedByWater());
        ListTag stickyBlocksTag = new ListTag();
        for (Block block : this.immuneToStickyBlocks) {
            ResourceLocation regKey = ForgeRegistries.BLOCKS.getKey((Object)block);
            if (regKey == null) continue;
            stickyBlocksTag.add((Object)StringTag.m_129297_((String)SpecialMobs.toString(regKey)));
        }
        tag.m_128365_("StickyImmune", (Tag)stickyBlocksTag);
        ListTag potionsTag = new ListTag();
        for (MobEffect effect : this.immuneToPotions) {
            ResourceLocation regKey = ForgeRegistries.MOB_EFFECTS.getKey((Object)effect);
            if (regKey == null) continue;
            potionsTag.add((Object)StringTag.m_129297_((String)SpecialMobs.toString(regKey)));
        }
        tag.m_128365_("PotionImmune", (Tag)potionsTag);
        if (this.getRangedAttackDamage() >= 0.0f) {
            tag.m_128350_("RangedDamage", this.getRangedAttackDamage());
        }
        if (this.getRangedAttackSpread() >= 0.0f) {
            tag.m_128350_("RangedSpread", this.getRangedAttackSpread());
        }
        if (this.getRangedWalkSpeed() >= 0.0f) {
            tag.m_128350_("RangedWalkSpeed", this.getRangedWalkSpeed());
        }
        if (this.getRangedAttackCooldown() >= 0) {
            tag.m_128376_("RangedCDMin", (short)this.getRangedAttackCooldown());
        }
        if (this.getRangedAttackMaxCooldown() >= 0) {
            tag.m_128376_("RangedCDMax", (short)this.getRangedAttackMaxCooldown());
        }
        if (this.getRangedAttackMaxRange() >= 0.0f) {
            tag.m_128350_("MaxRange", this.getRangedAttackMaxRange());
        }
    }

    public void readFromNBT(CompoundTag tag) {
        int i;
        if (tag.m_128425_("RenderScale", 99)) {
            this.setRenderScale(tag.m_128457_("RenderScale"));
        }
        if (tag.m_128425_("Experience", 99)) {
            ((ISpecialMob)this.theEntity).setExperience(tag.m_128451_("Experience"));
        }
        if (tag.m_128425_("Regeneration", 99)) {
            this.healTimeMax = tag.m_128445_("Regeneration");
        }
        if (tag.m_128425_("FallMulti", 99)) {
            this.setFallDamageMultiplier(tag.m_128457_("FallMulti"));
        }
        if (tag.m_128425_("FireImmune", 99)) {
            this.setImmuneToFire(tag.m_128471_("FireImmune"));
        }
        if (tag.m_128425_("BurningImmune", 99)) {
            this.setImmuneToBurning(tag.m_128471_("BurningImmune"));
        }
        if (tag.m_128425_("DrownImmune", 99)) {
            this.setCanBreatheInWater(tag.m_128471_("DrownImmune"));
        }
        if (tag.m_128425_("WaterPushImmune", 99)) {
            this.setIgnoreWaterPush(tag.m_128471_("WaterPushImmune"));
        }
        if (tag.m_128425_("WaterDamage", 99)) {
            this.setDamagedByWater(tag.m_128471_("WaterDamage"));
        }
        if (tag.m_128425_("Leashable", 99)) {
            this.setAllowLeashing(tag.m_128471_("Leashable"));
        }
        if (tag.m_128425_("UnderPressure", 99)) {
            this.setIgnorePressurePlates(tag.m_128471_("UnderPressure"));
        }
        if (tag.m_128425_("StickyImmune", References.NBT_TYPE_LIST)) {
            ListTag stickyBlocksTag = tag.m_128437_("StickyImmune", References.NBT_TYPE_STRING);
            this.immuneToStickyBlocks.clear();
            for (i = 0; i < stickyBlocksTag.size(); ++i) {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(stickyBlocksTag.m_128778_(i)));
                if (block == null || block.m_49966_().m_60713_(Blocks.f_50016_)) continue;
                this.immuneToStickyBlocks.add(block);
            }
        }
        if (tag.m_128425_("PotionImmune", References.NBT_TYPE_LIST)) {
            ListTag potionsTag = tag.m_128437_("PotionImmune", References.NBT_TYPE_STRING);
            this.immuneToPotions.clear();
            for (i = 0; i < potionsTag.size(); ++i) {
                MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(potionsTag.m_128778_(i)));
                if (effect == null) continue;
                this.immuneToPotions.add(effect);
            }
        }
        if (tag.m_128425_("RangedDamage", 99)) {
            this.setRangedAttackDamage(tag.m_128457_("RangedDamage"));
        }
        if (tag.m_128425_("RangedSpread", 99)) {
            this.setRangedAttackSpread(tag.m_128457_("RangedSpread"));
        }
        if (tag.m_128425_("RangedWalkSpeed", 99)) {
            this.setRangedWalkSpeed(tag.m_128457_("RangedWalkSpeed"));
        }
        if (tag.m_128425_("RangedCDMin", 99)) {
            this.setRangedAttackCooldown(tag.m_128448_("RangedCDMin"));
        }
        if (tag.m_128425_("RangedCDMax", 99)) {
            this.setRangedAttackMaxCooldown(tag.m_128448_("RangedCDMax"));
        }
        if (tag.m_128425_("MaxRange", 99)) {
            this.setRangedAttackMaxRange(tag.m_128457_("MaxRange"));
        }
    }
}

