/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai;

import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialHurtByTargetGoal;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;

public final class AIHelper {
    public static void insertGoal(GoalSelector ai, int priority, Goal goal) {
        for (WrappedGoal task : new ArrayList(ai.f_25345_)) {
            if (task.m_26012_() < priority) continue;
            ++task.f_25995_;
        }
        ai.m_25352_(priority, goal);
    }

    public static void insertGoalReverse(GoalSelector ai, int priority, Goal goal) {
        for (WrappedGoal task : new ArrayList(ai.f_25345_)) {
            if (task.m_26012_() > priority) continue;
            --task.f_25995_;
        }
        ai.m_25352_(priority, goal);
    }

    public static void removeGoals(GoalSelector ai, int priority) {
        for (WrappedGoal task : new ArrayList(ai.f_25345_)) {
            if (task.m_26012_() != priority) continue;
            ai.m_25363_(task.m_26015_());
        }
    }

    public static void removeGoals(GoalSelector ai, Class<? extends Goal> goalType) {
        for (WrappedGoal task : new ArrayList(ai.f_25345_)) {
            if (!task.m_26015_().getClass().equals(goalType)) continue;
            ai.m_25363_(task.m_26015_());
        }
    }

    @Nullable
    public static Goal getGoal(GoalSelector ai, int priority) {
        for (WrappedGoal task : new ArrayList(ai.f_25345_)) {
            if (task.m_26012_() != priority) continue;
            return task.m_26015_();
        }
        SpecialMobs.LOG.warn("Attempted to get '{}'-priority goal, but none exists!", (Object)priority);
        return null;
    }

    @Nullable
    public static Goal getGoal(GoalSelector ai, Class<? extends Goal> goalType) {
        for (WrappedGoal task : new ArrayList(ai.f_25345_)) {
            if (!task.m_26015_().getClass().equals(goalType)) continue;
            return task.m_26015_();
        }
        SpecialMobs.LOG.warn("Attempted to get '{}' goal, but none exists!", (Object)goalType.getSimpleName());
        return null;
    }

    public static void replaceWaterAvoidingRandomWalking(PathfinderMob entity, double speedModifier) {
        for (WrappedGoal task : new ArrayList(entity.f_21345_.f_25345_)) {
            if (!(task.m_26015_() instanceof WaterAvoidingRandomStrollGoal)) continue;
            int priority = task.m_26012_();
            entity.f_21345_.m_25363_(task.m_26015_());
            entity.f_21345_.m_25352_(priority, (Goal)new RandomStrollGoal(entity, speedModifier));
            return;
        }
        SpecialMobs.LOG.warn("Attempted to replace random walking goal for {}, but none exists!", (Object)entity.getClass().getSimpleName());
    }

    public static void replaceHurtByTarget(PathfinderMob entity, SpecialHurtByTargetGoal replacement) {
        for (WrappedGoal task : new ArrayList(entity.f_21346_.f_25345_)) {
            if (!(task.m_26015_() instanceof HurtByTargetGoal)) continue;
            int priority = task.m_26012_();
            entity.f_21346_.m_25363_(task.m_26015_());
            entity.f_21346_.m_25352_(priority, (Goal)replacement);
            return;
        }
        SpecialMobs.LOG.warn("Attempted to replace hurt by target goal for {}, but none exists!", (Object)entity.getClass().getSimpleName());
    }
}

