/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class SimpleFlyingMovementController
extends MoveControl {
    private int floatDuration;

    public SimpleFlyingMovementController(Mob entity) {
        super(entity);
    }

    public void m_8126_() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
            this.floatDuration = this.f_24974_.m_217043_().m_188503_(5) + 2;
            Vec3 moveVec = new Vec3(this.f_24975_ - this.f_24974_.m_20185_(), this.f_24976_ - this.f_24974_.m_20186_(), this.f_24977_ - this.f_24974_.m_20189_());
            int distance = Mth.m_14165_((double)moveVec.m_82553_());
            moveVec = moveVec.m_82541_();
            if (this.f_24974_.m_217043_().m_188499_() || this.canReach(moveVec, distance)) {
                this.f_24974_.m_20256_(this.f_24974_.m_20184_().m_82549_(moveVec.m_82490_(this.getScaledMoveSpeed())));
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
        }
    }

    public double getScaledMoveSpeed() {
        return 0.1 * this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_) / Attributes.f_22279_.m_22082_();
    }

    public double getDistanceSqToWantedPosition() {
        return this.f_24974_.m_20275_(this.m_25000_(), this.m_25001_(), this.m_25002_());
    }

    public boolean isWantedPositionStale(LivingEntity target) {
        return !this.m_24995_() || target.m_20275_(this.m_25000_(), this.m_25001_() - (double)(target.m_20206_() / 2.0f), this.m_25002_()) > 1.0;
    }

    public boolean canReachWantedPosition() {
        return this.m_24995_() && this.canReachPosition(this.m_25000_(), this.m_25001_(), this.m_25002_());
    }

    public boolean canReachPosition(LivingEntity target) {
        return this.canReachPosition(target.m_20185_(), target.m_20227_(0.5), target.m_20189_());
    }

    public boolean canReachPosition(double x, double y, double z) {
        Vec3 targetVec = new Vec3(x - this.f_24974_.m_20185_(), y - this.f_24974_.m_20186_(), z - this.f_24974_.m_20189_());
        int distance = Mth.m_14165_((double)targetVec.m_82553_());
        return this.canReach(targetVec.m_82541_(), distance);
    }

    private boolean canReach(Vec3 direction, int distance) {
        AABB boundingBox = this.f_24974_.m_20191_();
        for (int i = 1; i < distance; ++i) {
            boundingBox = boundingBox.m_82383_(direction);
            if (this.f_24974_.m_9236_().m_45756_((Entity)this.f_24974_, boundingBox)) continue;
            return false;
        }
        return true;
    }
}

