/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.IAngler;
import fathertoast.specialmobs.common.entity.projectile.SpecialFishingBobberEntity;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class AnglerGoal<T extends Mob & IAngler>
extends Goal {
    private final T mob;
    private SpecialFishingBobberEntity bobber;
    private int castTime;

    public AnglerGoal(T entity) {
        this.mob = entity;
    }

    private void setBobber(@Nullable SpecialFishingBobberEntity newBobber) {
        if (this.bobber != null) {
            this.bobber.m_146870_();
        }
        this.bobber = newBobber;
        ((IAngler)this.mob).setLineOut(newBobber != null);
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && ((ISpecialMob)this.mob).getSpecialData().getRangedAttackMaxRange() > 4.0f;
    }

    public void m_8041_() {
        this.setBobber(null);
        this.castTime = 0;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        if (this.bobber != null && !this.bobber.m_6084_()) {
            this.bobber = null;
            ((IAngler)this.mob).setLineOut(false);
        }
        SpecialMobData data = ((ISpecialMob)this.mob).getSpecialData();
        double distSqr = target.m_20280_(this.mob);
        if (distSqr > 16.0 && distSqr <= (double)(data.getRangedAttackMaxRange() * data.getRangedAttackMaxRange()) && this.mob.m_142582_((Entity)target)) {
            ++this.castTime;
            if (this.castTime >= data.getRangedAttackCooldown() && this.mob.m_217043_().m_188503_(5) == 0) {
                this.castTime = 0;
                SpecialFishingBobberEntity newBobber = new SpecialFishingBobberEntity((LivingEntity)this.mob, target);
                this.mob.m_5496_(SoundEvents.f_11941_, 1.0f, 0.4f / (this.mob.m_217043_().m_188501_() * 0.4f + 0.8f));
                this.mob.m_9236_().m_7967_((Entity)newBobber);
                this.setBobber(newBobber);
            }
        } else if (this.castTime > 0) {
            --this.castTime;
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

