/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.misc.MobBoat;
import fathertoast.specialmobs.common.network.NetworkHelper;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class ControlBoatGoal
extends Goal {
    private final Mob mob;
    private final double sqrStartDist;
    private final double sqrStopDist;

    public ControlBoatGoal(Mob mob, double sqrStartDist, double sqrStopDist) {
        this.mob = mob;
        if (sqrStartDist == sqrStopDist || sqrStopDist > sqrStartDist) {
            throw new IllegalArgumentException("Stop distance must be lesser than start distance for ControlBoatGoal!");
        }
        this.sqrStartDist = sqrStartDist;
        this.sqrStopDist = sqrStopDist;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        return this.mob.m_6084_() && this.mob.m_5448_() != null && this.mob.m_20280_((Entity)this.mob.m_5448_()) >= this.sqrStartDist && this.mob.m_20202_() instanceof MobBoat;
    }

    public boolean m_8045_() {
        return this.mob.m_6084_() && this.mob.m_5448_() != null && this.mob.m_20280_((Entity)this.mob.m_5448_()) > this.sqrStopDist && this.mob.m_20202_() instanceof MobBoat;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8041_() {
        Entity entity = this.mob.m_20202_();
        if (entity instanceof MobBoat) {
            MobBoat boat = (MobBoat)entity;
            boat.setInput(false, false, false, false);
            NetworkHelper.sendUpdateBoatInputs(boat, false, false, false, false);
        }
    }

    public void m_8037_() {
        if (this.mob.m_5448_() == null || this.mob.m_20202_() == null) {
            return;
        }
        MobBoat boat = (MobBoat)this.mob.m_20202_();
        if (boat.m_5842_()) {
            Vec3 dismountLoc = boat.m_7688_((LivingEntity)this.mob);
            this.mob.m_142098_(dismountLoc.f_82479_, dismountLoc.f_82480_, dismountLoc.f_82481_);
            return;
        }
        Vec3 boatPosition = boat.m_20182_();
        Vec3 boatViewVec = boat.m_20252_(0.0f).m_82541_();
        Vec3 targetVec = this.mob.m_5448_().m_20182_().m_82546_(boatPosition).m_82541_();
        double deviation = boatViewVec.f_82479_ * targetVec.f_82481_ - boatViewVec.f_82481_ * targetVec.f_82479_;
        boolean left = deviation < 0.2;
        boolean right = deviation > -0.2;
        boat.setInput(left, right, true, false);
        NetworkHelper.sendUpdateBoatInputs(boat, true, false, left, right);
    }
}

