/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.ai.INinja;
import java.util.ArrayList;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class NinjaGoal<T extends Mob>
extends Goal {
    private final T ninja;

    public NinjaGoal(T entity) {
        this.ninja = entity;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (((INinja)this.ninja).getHiddenDragon() == null || ((INinja)this.ninja).getHiddenDragon().m_60799_() == RenderShape.INVISIBLE) {
            return false;
        }
        ArrayList players = new ArrayList(this.ninja.m_9236_().m_6907_());
        for (Player player : players) {
            float dZ;
            float dX = (float)(this.ninja.m_20185_() - player.m_20185_());
            float angleFromPlayer = (float)Math.atan2(dX, -(dZ = (float)(this.ninja.m_20189_() - player.m_20189_()))) * 180.0f / (float)Math.PI;
            if (!(Math.abs(angleFromPlayer - Mth.m_14177_((float)player.f_20885_)) > 90.0f)) continue;
            return true;
        }
        return false;
    }

    public void m_8056_() {
        this.ninja.m_21573_().m_26573_();
        this.ninja.m_20095_();
        this.ninja.m_6027_(Math.floor(this.ninja.m_20185_()) + 0.5, Math.floor(this.ninja.m_20186_()), Math.floor(this.ninja.m_20189_()) + 0.5);
        this.ninja.m_20334_(0.0, 0.0, 0.0);
        ((INinja)this.ninja).setCrouchingTiger(true);
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public boolean m_6767_() {
        return false;
    }

    public void m_8041_() {
        ((INinja)this.ninja).setCrouchingTiger(false);
    }

    public static <T extends Mob> BlockState pickDisguise(T entity) {
        RandomSource random = entity.m_217043_();
        switch (random.m_188503_(200)) {
            case 0: {
                return Blocks.f_50077_.m_49966_();
            }
            case 1: {
                return Blocks.f_49999_.m_49966_();
            }
            case 2: {
                return Blocks.f_50056_.m_49966_();
            }
            case 3: {
                return Blocks.f_50036_.m_49966_();
            }
            case 4: {
                return Blocks.f_50050_.m_49966_();
            }
            case 5: {
                return NinjaGoal.randomRotation(Blocks.f_50717_.m_49966_(), random);
            }
            case 6: {
                return Blocks.f_50145_.m_49966_();
            }
            case 7: {
                return Blocks.f_50091_.m_49966_();
            }
            case 8: {
                return NinjaGoal.randomRotation(Blocks.f_50094_.m_49966_(), random);
            }
            case 9: {
                return NinjaGoal.randomRotation(Blocks.f_50322_.m_49966_(), random);
            }
            case 10: {
                return Blocks.f_50255_.m_49966_();
            }
            case 11: {
                return NinjaGoal.randomRotation((BlockState)Blocks.f_50164_.m_49966_().m_61124_((Property)BlockStateProperties.f_61376_, (Comparable)AttachFace.FLOOR), random);
            }
            case 12: {
                return NinjaGoal.randomPottedFlower(random);
            }
            case 13: {
                return (BlockState)Blocks.f_50685_.m_49966_().m_61124_((Property)SweetBerryBushBlock.f_57244_, (Comparable)Integer.valueOf(3));
            }
            case 14: {
                return Blocks.f_50453_.m_49966_();
            }
            case 15: {
                return Blocks.f_50078_.m_49966_();
            }
            case 16: {
                return Blocks.f_50031_.m_49966_();
            }
        }
        BlockPos posUnderFeet = entity.m_20183_().m_7495_();
        BlockState blockUnderFeet = entity.m_9236_().m_8055_(posUnderFeet);
        if (!blockUnderFeet.m_60795_()) {
            if (blockUnderFeet.m_60713_(Blocks.f_50069_) || blockUnderFeet.m_60713_(Blocks.f_50222_)) {
                switch (random.m_188503_(30)) {
                    case 0: {
                        return Blocks.f_50072_.m_49966_();
                    }
                    case 1: {
                        return Blocks.f_50073_.m_49966_();
                    }
                    case 2: {
                        return Blocks.f_50129_.m_49966_();
                    }
                    case 3: {
                        return Blocks.f_49994_.m_49966_();
                    }
                    case 4: {
                        return Blocks.f_49997_.m_49966_();
                    }
                    case 5: {
                        return Blocks.f_49996_.m_49966_();
                    }
                    case 6: {
                        return Blocks.f_50059_.m_49966_();
                    }
                    case 7: {
                        return Blocks.f_49995_.m_49966_();
                    }
                    case 8: {
                        return Blocks.f_50173_.m_49966_();
                    }
                    case 9: {
                        return Blocks.f_50089_.m_49966_();
                    }
                    case 10: {
                        return Blocks.f_50264_.m_49966_();
                    }
                    case 11: {
                        return Blocks.f_152505_.m_49966_();
                    }
                    case 12: {
                        return Blocks.f_50079_.m_49966_();
                    }
                }
            } else if (blockUnderFeet.m_60713_(Blocks.f_152550_)) {
                switch (random.m_188503_(30)) {
                    case 0: {
                        return Blocks.f_50072_.m_49966_();
                    }
                    case 1: {
                        return Blocks.f_50073_.m_49966_();
                    }
                    case 2: {
                        return Blocks.f_152496_.m_49966_();
                    }
                    case 3: {
                        return Blocks.f_49994_.m_49966_();
                    }
                    case 4: {
                        return Blocks.f_152469_.m_49966_();
                    }
                    case 5: {
                        return Blocks.f_152468_.m_49966_();
                    }
                    case 6: {
                        return Blocks.f_152472_.m_49966_();
                    }
                    case 7: {
                        return Blocks.f_152467_.m_49966_();
                    }
                    case 8: {
                        return Blocks.f_152473_.m_49966_();
                    }
                    case 9: {
                        return Blocks.f_152474_.m_49966_();
                    }
                    case 10: {
                        return Blocks.f_152479_.m_49966_();
                    }
                    case 11: {
                        return Blocks.f_152506_.m_49966_();
                    }
                    case 12: {
                        return Blocks.f_152550_.m_49966_();
                    }
                    case 13: {
                        return Blocks.f_152591_.m_49966_();
                    }
                    case 14: {
                        return Blocks.f_220855_.m_49966_();
                    }
                    case 15: {
                        return Blocks.f_220857_.m_49966_();
                    }
                }
            } else if (blockUnderFeet.m_60713_(Blocks.f_50034_) || blockUnderFeet.m_60713_(Blocks.f_50493_) || blockUnderFeet.m_60713_(Blocks.f_50599_)) {
                switch (random.m_188503_(20)) {
                    case 0: {
                        return blockUnderFeet;
                    }
                    case 1: {
                        return Blocks.f_49999_.m_49966_();
                    }
                    case 2: {
                        return Blocks.f_50050_.m_49966_();
                    }
                    case 3: {
                        return Blocks.f_50133_.m_49966_();
                    }
                    case 4: {
                        return Blocks.f_50186_.m_49966_();
                    }
                    case 5: {
                        return Blocks.f_50359_.m_49966_();
                    }
                    case 6: {
                        return Blocks.f_50035_.m_49966_();
                    }
                    case 7: {
                        return NinjaGoal.randomRotation(Blocks.f_50717_.m_49966_(), random);
                    }
                    case 8: {
                        return NinjaGoal.randomFlower(random);
                    }
                    case 9: {
                        return NinjaGoal.randomPottedFlower(random);
                    }
                    case 10: {
                        return NinjaGoal.randomPottedPlant(random);
                    }
                }
            } else if (blockUnderFeet.m_60713_(Blocks.f_49992_) || blockUnderFeet.m_60713_(Blocks.f_49993_) || blockUnderFeet.m_60713_(Blocks.f_50062_) || blockUnderFeet.m_60713_(Blocks.f_50394_)) {
                switch (random.m_188503_(5)) {
                    case 0: {
                        return Blocks.f_50128_.m_49966_();
                    }
                    case 1: {
                        return Blocks.f_50036_.m_49966_();
                    }
                    case 2: {
                        return NinjaGoal.randomPottedDesertPlant(random);
                    }
                }
            } else if (blockUnderFeet.m_60713_(Blocks.f_50134_) || blockUnderFeet.m_60713_(Blocks.f_50197_) || blockUnderFeet.m_60713_(Blocks.f_50135_) || blockUnderFeet.m_60713_(Blocks.f_50136_) || blockUnderFeet.m_60713_(Blocks.f_50699_) || blockUnderFeet.m_60713_(Blocks.f_50690_)) {
                switch (random.m_188503_(25)) {
                    case 0: {
                        return blockUnderFeet;
                    }
                    case 1: {
                        return Blocks.f_49994_.m_49966_();
                    }
                    case 2: {
                        return Blocks.f_50331_.m_49966_();
                    }
                    case 3: {
                        return Blocks.f_49998_.m_49966_();
                    }
                    case 4: {
                        return Blocks.f_50722_.m_49966_();
                    }
                    case 5: {
                        return Blocks.f_50072_.m_49966_();
                    }
                    case 6: {
                        return Blocks.f_50073_.m_49966_();
                    }
                    case 7: {
                        return Blocks.f_50695_.m_49966_();
                    }
                    case 8: {
                        return Blocks.f_50686_.m_49966_();
                    }
                    case 9: {
                        return Blocks.f_50654_.m_49966_();
                    }
                    case 10: {
                        return Blocks.f_50693_.m_49966_();
                    }
                    case 11: {
                        return Blocks.f_50700_.m_49966_();
                    }
                    case 12: {
                        return Blocks.f_50691_.m_49966_();
                    }
                    case 13: {
                        return NinjaGoal.randomPottedNetherThing(random);
                    }
                }
            } else if (blockUnderFeet.m_60713_(Blocks.f_50259_) || blockUnderFeet.m_60713_(Blocks.f_50443_) || blockUnderFeet.m_60713_(Blocks.f_50492_)) {
                switch (random.m_188503_(10)) {
                    case 0: {
                        return Blocks.f_50490_.m_49966_();
                    }
                    case 1: {
                        return Blocks.f_50441_.m_49966_();
                    }
                    case 2: {
                        return NinjaGoal.randomPottedEndThing(random);
                    }
                }
            }
        }
        BlockPos.MutableBlockPos randPos = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 16; ++i) {
            randPos.m_122178_(posUnderFeet.m_123341_() + random.m_188503_(17) - 8, posUnderFeet.m_123342_() + random.m_188503_(5) - 2, posUnderFeet.m_123343_() + random.m_188503_(17) - 8);
            BlockState randBlock = entity.m_9236_().m_8055_((BlockPos)randPos);
            if (randBlock.m_60799_() != RenderShape.MODEL) continue;
            return randBlock;
        }
        return Blocks.f_49999_.m_49966_();
    }

    private static BlockState randomRotation(BlockState block, RandomSource random) {
        return (BlockState)block.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random));
    }

    private static BlockState randomFlower(RandomSource random) {
        return ForgeRegistries.BLOCKS.tags().getTag(BlockTags.f_13037_).getRandomElement(random).orElse(Blocks.f_50112_).m_49966_();
    }

    private static BlockState randomPottedFlower(RandomSource random) {
        return switch (random.m_188503_(12)) {
            case 0 -> Blocks.f_50232_.m_49966_();
            case 1 -> Blocks.f_50233_.m_49966_();
            case 2 -> Blocks.f_50234_.m_49966_();
            case 3 -> Blocks.f_50235_.m_49966_();
            case 4 -> Blocks.f_50236_.m_49966_();
            case 5 -> Blocks.f_50237_.m_49966_();
            case 6 -> Blocks.f_50238_.m_49966_();
            case 7 -> Blocks.f_50239_.m_49966_();
            case 8 -> Blocks.f_50240_.m_49966_();
            case 9 -> Blocks.f_50241_.m_49966_();
            case 10 -> Blocks.f_50242_.m_49966_();
            default -> Blocks.f_50243_.m_49966_();
        };
    }

    private static BlockState randomPottedPlant(RandomSource random) {
        return switch (random.m_188503_(8)) {
            case 0 -> Blocks.f_50277_.m_49966_();
            case 1 -> Blocks.f_50278_.m_49966_();
            case 2 -> Blocks.f_50279_.m_49966_();
            case 3 -> Blocks.f_50280_.m_49966_();
            case 4 -> Blocks.f_50229_.m_49966_();
            case 5 -> Blocks.f_50230_.m_49966_();
            case 6 -> Blocks.f_50231_.m_49966_();
            default -> Blocks.f_50572_.m_49966_();
        };
    }

    private static BlockState randomPottedDesertPlant(RandomSource random) {
        return switch (random.m_188503_(2)) {
            case 0 -> Blocks.f_50247_.m_49966_();
            default -> Blocks.f_50248_.m_49966_();
        };
    }

    private static BlockState randomPottedNetherThing(RandomSource random) {
        return switch (random.m_188503_(7)) {
            case 0 -> Blocks.f_50244_.m_49966_();
            case 1 -> Blocks.f_50245_.m_49966_();
            case 2 -> Blocks.f_50246_.m_49966_();
            case 3 -> Blocks.f_50725_.m_49966_();
            case 4 -> Blocks.f_50726_.m_49966_();
            case 5 -> Blocks.f_50727_.m_49966_();
            default -> Blocks.f_50728_.m_49966_();
        };
    }

    private static BlockState randomPottedEndThing(RandomSource random) {
        return switch (random.m_188503_(5)) {
            case 0 -> Blocks.f_50244_.m_49966_();
            case 1 -> Blocks.f_50235_.m_49966_();
            case 2 -> Blocks.f_50236_.m_49966_();
            case 3 -> Blocks.f_50241_.m_49966_();
            default -> Blocks.f_50243_.m_49966_();
        };
    }
}

