/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class PassiveRangedAttackGoal<T extends Mob & RangedAttackMob>
extends Goal {
    private final T mob;
    private final float recoilPower;
    private int attackTime;

    public PassiveRangedAttackGoal(T entity) {
        this(entity, 0.0f);
    }

    public PassiveRangedAttackGoal(T entity, float recoil) {
        this.mob = entity;
        this.recoilPower = recoil;
    }

    public boolean m_8036_() {
        return this.mob.m_5448_() != null && ((ISpecialMob)this.mob).getSpecialData().getRangedAttackMaxRange() > 0.0f;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return;
        }
        SpecialMobData data = ((ISpecialMob)this.mob).getSpecialData();
        double distSqr = target.m_20280_(this.mob);
        if (distSqr <= (double)(data.getRangedAttackMaxRange() * data.getRangedAttackMaxRange()) && this.mob.m_142582_((Entity)target)) {
            ++this.attackTime;
            if (this.attackTime >= data.getRangedAttackCooldown()) {
                this.attackTime = Mth.m_14143_((float)((float)(data.getRangedAttackCooldown() - data.getRangedAttackMaxCooldown()) * Mth.m_14116_((float)((float)distSqr)) / data.getRangedAttackMaxRange()));
                ((RangedAttackMob)this.mob).m_6504_(target, 1.0f);
                if (this.recoilPower != 0.0f) {
                    MobHelper.knockback(this.mob, this.recoilPower, 0.0f, target.m_20185_() - this.mob.m_20185_(), target.m_20189_() - this.mob.m_20189_(), 0.2);
                }
            }
        } else if (this.attackTime < 0) {
            ++this.attackTime;
        } else if (this.attackTime > 0) {
            --this.attackTime;
        }
    }

    public boolean m_183429_() {
        return true;
    }
}

