/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ai.goal;

import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.enderman.RunicEndermanEntity;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class RunicEndermanBeamAttackGoal
extends Goal {
    private final RunicEndermanEntity mob;
    private final DamageSource beamDamageSource;
    private LivingEntity targetEntity;
    private Vec3 targetPos;
    private int attackTime;

    public RunicEndermanBeamAttackGoal(RunicEndermanEntity entity) {
        this.mob = entity;
        this.beamDamageSource = entity.m_269291_().m_269104_((Entity)entity, null);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.mob.m_20160_()) {
            return false;
        }
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_() && this.mob.m_21574_().m_148306_((Entity)target) && this.mob.f_19797_ % 8 <= 1 && this.mob.m_217043_().m_188503_(10) == 0 && this.isTargetWithinBeamRange(target)) {
            this.targetEntity = target;
            this.updateTargetPos();
            this.attackTime = 0;
            this.mob.setBeamState(RunicEndermanEntity.BeamState.CHARGING);
            if (!this.mob.m_20067_()) {
                this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_(), SoundEvents.f_11850_, this.mob.m_5720_(), 1.0f, 1.0f / (this.mob.m_217043_().m_188501_() * 0.2f + 1.8f));
            }
            return true;
        }
        return false;
    }

    private boolean isTargetWithinBeamRange(LivingEntity target) {
        return target.m_20280_((Entity)this.mob) <= (double)(this.mob.getSpecialData().getRangedAttackMaxRange() * this.mob.getSpecialData().getRangedAttackMaxRange());
    }

    public boolean m_8045_() {
        return (this.mob.getBeamState() == RunicEndermanEntity.BeamState.DAMAGING || this.targetEntity != null && this.targetEntity.m_6084_()) && this.attackTime < this.mob.getSpecialData().getRangedAttackMaxCooldown();
    }

    public void m_8041_() {
        this.targetEntity = null;
        this.targetPos = null;
        this.mob.setBeamState(RunicEndermanEntity.BeamState.OFF);
    }

    public void m_8037_() {
        ++this.attackTime;
        switch (this.mob.getBeamState()) {
            case CHARGING: {
                this.chargingTick();
                break;
            }
            case DAMAGING: {
                this.damagingTick();
            }
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_6767_() {
        return false;
    }

    private void chargingTick() {
        this.mob.m_21563_().m_24950_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, 10.0f, (float)this.mob.m_8132_());
        if (this.attackTime >= this.mob.getSpecialData().getRangedAttackCooldown()) {
            this.mob.setBeamState(RunicEndermanEntity.BeamState.DAMAGING);
        }
    }

    private void damagingTick() {
        if (this.targetEntity != null) {
            this.updateTargetPos();
        }
        if (!this.mob.m_20067_() && this.attackTime % 10 == 0) {
            this.mob.m_9236_().m_6263_(null, this.mob.m_20185_(), this.mob.m_20188_(), this.mob.m_20189_(), SoundEvents.f_11850_, this.mob.m_5720_(), 1.0f, 1.0f / (this.mob.m_217043_().m_188501_() * 0.4f + 1.0f));
        }
        this.lookTowardTarget(1.7f * this.mob.getSpecialData().getRangedWalkSpeed());
        Vec3 viewVec = this.mob.m_20252_(1.0f).m_82490_(32.0);
        Vec3 beamStartPos = this.mob.m_20299_(1.0f);
        Vec3 beamEndPos = beamStartPos.m_82549_(viewVec);
        BlockHitResult blockRayTrace = this.mob.m_9236_().m_45547_(new ClipContext(beamStartPos, beamEndPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.mob));
        if (blockRayTrace.m_6662_() != HitResult.Type.MISS) {
            beamEndPos = blockRayTrace.m_82450_();
        }
        List<Entity> hitEntities = this.rayTraceEntities(beamStartPos, beamEndPos, this.mob.m_20191_().m_82369_(viewVec).m_82400_(1.0));
        for (Entity entity : hitEntities) {
            if (entity instanceof EnderMan || entity instanceof EnderDragon) {
                if (this.mob.f_19797_ % 10 != 0) continue;
                ((Mob)entity).m_5634_(1.0f);
                continue;
            }
            if (!entity.m_6469_(this.beamDamageSource, this.mob.getSpecialData().getRangedAttackDamage()) || !(entity instanceof LivingEntity)) continue;
            MobHelper.knockback((LivingEntity)entity, 1.0f, 1.0f, -viewVec.f_82479_, -viewVec.f_82481_, 1.0);
        }
    }

    private void updateTargetPos() {
        this.targetPos = new Vec3(this.targetEntity.m_20185_(), this.targetEntity.m_20227_(0.5), this.targetEntity.m_20189_());
    }

    private void lookTowardTarget(float speed) {
        double dX = this.targetPos.f_82479_ - this.mob.m_20185_();
        double dY = this.targetPos.f_82480_ - this.mob.m_20188_();
        double dZ = this.targetPos.f_82481_ - this.mob.m_20189_();
        double dH = Mth.m_14116_((float)((float)(dX * dX + dZ * dZ)));
        float targetXRot = (float)Mth.m_14136_((double)dY, (double)dH);
        float clampedXRot = (this.mob.m_146909_() + Mth.m_14036_((float)Mth.m_14118_((float)this.mob.m_146909_(), (float)(targetXRot * -57.295776f)), (float)(-speed), (float)speed)) / -57.295776f;
        double clampedDY = dH * (double)Mth.m_14031_((float)clampedXRot) / (double)Mth.m_14089_((float)clampedXRot);
        this.targetPos = this.targetPos.m_82520_(0.0, clampedDY - dY, 0.0);
        this.mob.m_21563_().m_24950_(this.targetPos.f_82479_, this.targetPos.f_82480_, this.targetPos.f_82481_, speed, (float)this.mob.m_8132_());
    }

    private List<Entity> rayTraceEntities(Vec3 from, Vec3 to, AABB searchArea) {
        ArrayList<Entity> entitiesHit = new ArrayList<Entity>();
        for (Entity entity : this.mob.m_9236_().m_6249_((Entity)this.mob, searchArea, this::canBeamHitTarget)) {
            Optional hitPos = entity.m_20191_().m_82400_(0.3).m_82371_(from, to);
            if (!hitPos.isPresent()) continue;
            entitiesHit.add(entity);
        }
        return entitiesHit;
    }

    private boolean canBeamHitTarget(@Nullable Entity entity) {
        return entity != null && !entity.m_5833_() && entity.m_6084_() && entity.m_6087_() && !entity.m_20365_((Entity)this.mob);
    }
}

