/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.ArmoredBlazeSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class ArmoredBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<ArmoredBlazeEntity> SPECIES;
    public static final EntityDataAccessor<Integer> ARMOR_LEVEL;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xE5E5E5).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureBaseOnly().addExperience(4).fireballAttack(0.0, 80, 120, 40.0).addToAttribute(Attributes.f_22276_, 15.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new ArmoredBlazeSpeciesConfig(manager, species, 5, 10, 5, 7);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Armored Blaze", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        ArmoredBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42585_);
        loot.addSemicommonDrop("semicommon", (ItemLike)Items.f_42416_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<ArmoredBlazeEntity> getVariantFactory() {
        return ArmoredBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends ArmoredBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public ArmoredBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ARMOR_LEVEL, (Object)this.getConfig().ARMORED.armor.next(this.f_19796_));
    }

    @Override
    public ArmoredBlazeSpeciesConfig getConfig() {
        return (ArmoredBlazeSpeciesConfig)this.getSpecies().config;
    }

    public boolean hasArmor() {
        return (Integer)this.f_19804_.m_135370_(ARMOR_LEVEL) > 0;
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if ((Integer)this.f_19804_.m_135370_(ARMOR_LEVEL) > 0) {
            Entity attacker;
            if (source.m_269533_(DamageTypeTags.f_268738_)) {
                return super.m_6469_(source, amount);
            }
            if (!source.m_269533_(SMTags.DamageTypes.IS_MAGIC) && !source.m_269533_(DamageTypeTags.f_268524_) && amount >= 2.0f) {
                int newArmorLevel = (Integer)this.f_19804_.m_135370_(ARMOR_LEVEL) - 1;
                this.f_19804_.m_135381_(ARMOR_LEVEL, (Object)newArmorLevel);
                if (newArmorLevel <= 0) {
                    if (!this.m_9236_().f_46443_) {
                        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)Items.f_42468_)), this.m_20185_() + 0.5, this.m_20186_() + 0.5, this.m_20189_() + 0.5, 5, 0.0, 0.0, 0.0, 0.2);
                        this.m_216990_(SoundEvents.f_12018_);
                    }
                } else {
                    this.m_5496_(SoundEvents.f_11669_, 0.8f, 0.8f + this.m_9236_().f_46441_.m_188501_() * 0.4f);
                }
            }
            if ((attacker = source.m_7640_()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)attacker;
                livingEntity.m_147240_(0.5, this.m_20185_() - attacker.m_20185_(), this.m_20189_() - attacker.m_20189_());
            }
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128405_("Ammo", ((Integer)this.f_19804_.m_135370_(ARMOR_LEVEL)).intValue());
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Ammo", 99)) {
            this.f_19804_.m_135381_(ARMOR_LEVEL, (Object)saveTag.m_128451_("Ammo"));
        }
    }

    static {
        ARMOR_LEVEL = SynchedEntityData.m_135353_(ArmoredBlazeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    }
}

