/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class ConflagrationBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<ConflagrationBlazeEntity> SPECIES;
    private static final AttributeModifier DAMAGE_BOOST;
    private int growthLevel;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16775294).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureBaseOnly().size(1.5f, 0.9f, 2.7f).addExperience(4).regen(20);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Conflagration", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        ConflagrationBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42613_);
        loot.addRareDrop("rare", PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43610_));
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<ConflagrationBlazeEntity> getVariantFactory() {
        return ConflagrationBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends ConflagrationBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public ConflagrationBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.stealLife((LivingEntity)this, target, 2.0f);
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) || this.m_5825_() && source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (!(source.m_269533_(DamageTypeTags.f_268415_) || source.m_269533_(SMTags.DamageTypes.IS_MAGIC) || source.m_269533_(DamageTypeTags.f_268581_) || source.m_7640_() instanceof Snowball)) {
            if (!this.m_9236_().m_5776_() && this.growthLevel < 7) {
                ++this.growthLevel;
                this.updateFeedingLevels();
            }
            amount /= 2.0f;
        }
        return super.m_6469_(source, amount);
    }

    private void updateFeedingLevels() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            int cooldownReduction = Mth.m_14107_((double)((double)(this.getConfig().GENERAL.rangedAttackCooldown.get() * this.growthLevel) * 0.1));
            this.getSpecialData().setRangedAttackCooldown(this.getConfig().GENERAL.rangedAttackCooldown.get() - cooldownReduction);
            this.getSpecialData().setRangedAttackMaxCooldown(this.getConfig().GENERAL.rangedAttackMaxCooldown.get() - cooldownReduction);
            this.fireballBurstCount = this.getConfig().BLAZES.fireballBurstCount.get();
            if (this.growthLevel >= 3) {
                ++this.fireballBurstCount;
            }
            if (this.growthLevel >= 7) {
                ++this.fireballBurstCount;
            }
            AttributeInstance damage = this.m_21051_(Attributes.f_22281_);
            damage.m_22120_(DAMAGE_BOOST.m_22209_());
            if (this.growthLevel > 0) {
                damage.m_22125_(new AttributeModifier(DAMAGE_BOOST.m_22209_(), DAMAGE_BOOST.m_22214_(), DAMAGE_BOOST.m_22218_() * (double)this.growthLevel, DAMAGE_BOOST.m_22217_()));
            }
        }
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("GrowthLevel", (byte)this.growthLevel);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("GrowthLevel", 99)) {
            this.growthLevel = saveTag.m_128445_("GrowthLevel");
        }
        this.updateFeedingLevels();
    }

    static {
        DAMAGE_BOOST = new AttributeModifier(UUID.fromString("70457CAB-AA09-4E1C-B44B-99DD4A2A836D"), "Feeding damage boost", 1.0, AttributeModifier.Operation.ADDITION);
    }
}

