/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class EmberBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<EmberBlazeEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0).uniqueTextureBaseOnly().addExperience(2).disableRangedAttack().addToAttribute(Attributes.f_22276_, 10.0).addToAttribute(Attributes.f_22284_, 10.0).multiplyAttribute(Attributes.f_22279_, 1.3);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Ember", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        EmberBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42413_, 1);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<EmberBlazeEntity> getVariantFactory() {
        return EmberBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends EmberBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public EmberBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.causeLifeLoss(target, 2.0f);
    }
}

