/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.BlazeSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class HellfireBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<HellfireBlazeEntity> SPECIES;
    private int explosionPower = 2;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDDDDD).uniqueTextureBaseOnly().size(1.1f, 0.7f, 1.99f).addExperience(2).fireballAttack(0.05, 60, 100, 40.0).addToAttribute(Attributes.f_22276_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new BlazeSpeciesConfig(manager, species, 1, 0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Hellfire", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        HellfireBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42403_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<HellfireBlazeEntity> getVariantFactory() {
        return HellfireBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends HellfireBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public HellfireBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void m_6504_(LivingEntity target, float damageMulti) {
        References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        float accelVariance = Mth.m_14116_((float)this.m_20270_((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        double dX = target.m_20185_() - this.m_20185_() + this.m_217043_().m_188583_() * (double)accelVariance;
        double dY = target.m_20227_(0.5) - this.m_20227_(0.5);
        double dZ = target.m_20189_() - this.m_20189_() + this.m_217043_().m_188583_() * (double)accelVariance;
        LargeFireball fireball = new LargeFireball(this.m_9236_(), (LivingEntity)this, dX, dY, dZ, this.explosionPower);
        fireball.m_6034_(fireball.m_20185_(), this.m_20227_(0.5) + 0.5, fireball.m_20189_());
        this.m_9236_().m_7967_((Entity)fireball);
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("ExplosionPower", (byte)this.explosionPower);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("ExplosionPower", 99)) {
            this.explosionPower = saveTag.m_128445_("ExplosionPower");
        }
    }
}

