/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.blaze._SpecialBlazeEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

@SpecialMob
public class JoltBlazeEntity
extends _SpecialBlazeEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<JoltBlazeEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(4824238).uniqueTextureBaseOnly().addExperience(2).disableRangedAttack().addToAttribute(Attributes.f_22276_, 10.0).addToAttribute(Attributes.f_22284_, 10.0).multiplyAttribute(Attributes.f_22279_, 1.3);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Jolt", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        JoltBlazeEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42451_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<JoltBlazeEntity> getVariantFactory() {
        return JoltBlazeEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends JoltBlazeEntity> getSpecies() {
        return SPECIES;
    }

    public JoltBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.m_6084_() && this.m_5448_() != null && this.f_19796_.m_188503_(20) == 0 && this.m_20280_((Entity)this.m_5448_()) > 256.0) {
            for (int i = 0; i < 16 && !this.teleportTowards((Entity)this.m_5448_()); ++i) {
            }
        }
        super.m_8107_();
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source) || this.m_5825_() && source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (source.m_269533_(DamageTypeTags.f_268524_)) {
            for (int i = 0; i < 64; ++i) {
                if (!this.teleport()) continue;
                return true;
            }
            return false;
        }
        boolean success = super.m_6469_(source, amount);
        if (!this.m_9236_().m_5776_() && this.m_21223_() > 0.0f) {
            if (source.m_7639_() instanceof LivingEntity) {
                for (int i = 0; i < 16 && !this.teleport(); ++i) {
                }
            } else if (this.f_19796_.m_188503_(10) != 0) {
                this.teleport();
            }
        }
        return success;
    }

    public void m_8038_(ServerLevel level, LightningBolt lightningBolt) {
    }

    protected boolean teleport() {
        if (this.m_9236_().m_5776_() || !this.m_6084_()) {
            return false;
        }
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(16) - 8);
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleportTowards(Entity target) {
        Vec3 directionFromTarget = new Vec3(this.m_20185_() - target.m_20185_(), this.m_20227_(0.5) - target.m_20188_(), this.m_20189_() - target.m_20189_()).m_82541_();
        double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - directionFromTarget.f_82479_ * 16.0;
        double y = this.m_20186_() + (double)(this.f_19796_.m_188503_(8) - 2) - directionFromTarget.f_82480_ * 16.0;
        double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 8.0 - directionFromTarget.f_82481_ * 16.0;
        return this.teleport(x, y, z);
    }

    protected boolean teleport(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > 0 && !this.m_9236_().m_8055_((BlockPos)pos).m_280555_()) {
            pos.m_122173_(Direction.DOWN);
        }
        BlockState block = this.m_9236_().m_8055_((BlockPos)pos);
        if (!block.m_280555_() || block.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)y, (double)z);
        if (event.isCanceled()) {
            return false;
        }
        boolean success = this.m_20984_(event.getTargetX(), event.getTargetY(), event.getTargetZ(), false);
        if (success) {
            ExplosionHelper.spawnLightning(this.m_9236_(), this.f_19854_, this.f_19855_, this.f_19856_);
            ExplosionHelper.spawnLightning(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        return success;
    }
}

