/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.blaze;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.BlazeSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialBlazeAttackGoal;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialHurtByTargetGoal;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Blaze;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class _SpecialBlazeEntity
extends Blaze
implements RangedAttackMob,
ISpecialMob<_SpecialBlazeEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialBlazeEntity> SPECIES;
    private static final EntityDataAccessor<Float> SCALE;
    public int fireballBurstCount;
    public int fireballBurstDelay;
    private SpecialMobData<_SpecialBlazeEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16775294).modBaseTexture("textures/entity/blaze/base_blaze.png").experience(10).waterSensitive().fallImmune().fireballAttack(1.0, 60, 100, 48.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new BlazeSpeciesConfig(manager, species, 3, 6);
    }

    public BlazeSpeciesConfig getConfig() {
        return (BlazeSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_32238_() {
        return Blaze.m_32238_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialBlazeEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, NaturalSpawnManager::checkSpawnRulesIgnoreLight);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Blaze", "Blaze", "Blaze", "Blaze", "Blaze", "Lohe", "Blisterin' Blaze");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20551_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.BLAZES, EntityTypeTags.f_144295_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<_SpecialBlazeEntity> getFactory() {
        return _SpecialBlazeEntity::new;
    }

    protected void m_8099_() {
        super.m_8099_();
        AIHelper.removeGoals(this.f_21345_, 4);
        this.f_21345_.m_25352_(4, (Goal)new SpecialBlazeAttackGoal(this));
        AIHelper.replaceHurtByTarget((PathfinderMob)this, new SpecialHurtByTargetGoal((PathfinderMob)this, Blaze.class, new Class[0]).setAlertOthers(new Class[0]));
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
    }

    public void m_19970_(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.m_19970_(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void m_6504_(LivingEntity target, float damageMulti) {
        References.LevelEvent.BLAZE_SHOOT.play((Entity)this);
        float accelVariance = Mth.m_14116_((float)this.m_20270_((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        double dX = target.m_20185_() - this.m_20185_() + this.m_217043_().m_188583_() * (double)accelVariance;
        double dY = target.m_20227_(0.5) - this.m_20227_(0.5);
        double dZ = target.m_20189_() - this.m_20189_() + this.m_217043_().m_188583_() * (double)accelVariance;
        SmallFireball fireball = new SmallFireball(this.m_9236_(), (LivingEntity)this, dX, dY, dZ);
        fireball.m_6034_(this.m_20185_(), this.m_20227_(0.5) + 0.5, this.m_20189_());
        this.m_9236_().m_7967_((Entity)fireball);
    }

    public void addVariantSaveData(CompoundTag saveTag) {
    }

    public void readVariantSaveData(CompoundTag saveTag) {
    }

    public _SpecialBlazeEntity(EntityType<? extends _SpecialBlazeEntity> entityType, Level level) {
        super(entityType, level);
        this.fireballBurstCount = this.getConfig().BLAZES.fireballBurstCount.get();
        this.fireballBurstDelay = this.getConfig().BLAZES.fireballBurstDelay.get();
        this.getSpecialData().initialize();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.specialData = new SpecialMobData<_SpecialBlazeEntity>(this, SCALE);
    }

    @Override
    public final SpecialMobData<_SpecialBlazeEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialBlazeEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.f_21364_;
    }

    @Override
    public final void setExperience(int xp) {
        this.f_21364_ = xp;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> entityType, boolean keepEquipment) {
        Level level;
        Mob replacement = super.m_21406_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            MobHelper.finalizeSpawn((LivingEntity)replacement, serverLevel, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, level, difficulty, spawnType, super.m_6518_(level, difficulty, spawnType, groupData, eggTag));
    }

    protected final void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.finalizeVariantSpawn(level, difficulty, spawnType, groupData);
    }

    @Override
    public void setSpecialPathfindingMalus(BlockPathTypes type, float malus) {
        this.m_21441_(type, malus);
    }

    public void m_8107_() {
        super.m_8107_();
        this.getSpecialData().tick();
    }

    public boolean m_5825_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void m_7311_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.m_7311_(ticks);
        }
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getSpecialData().allowLeashing();
    }

    public void m_7601_(BlockState block, Vec3 speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.m_7601_(block, speedMulti);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier(), damageSource);
    }

    public boolean m_6090_() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean m_6040_() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean m_6063_() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean m_6126_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() instanceof Snowball) {
            amount = this.m_6126_() ? Math.max(3.0f, amount) : 0.0f;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        saveTag.m_128344_("FireballBurstCount", (byte)this.fireballBurstCount);
        saveTag.m_128344_("FireballBurstDelay", (byte)this.fireballBurstDelay);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        if (saveTag.m_128425_("FireballBurstCount", 99)) {
            this.fireballBurstCount = saveTag.m_128445_("FireballBurstCount");
        }
        if (saveTag.m_128425_("FireballBurstDelay", 99)) {
            this.fireballBurstDelay = saveTag.m_128445_("FireballBurstDelay");
        }
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
    }

    static {
        SCALE = SynchedEntityData.m_135353_(_SpecialBlazeEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

