/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.cavespider;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.cavespider._SpecialCaveSpiderEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

@SpecialMob
public class WitchCaveSpiderEntity
extends _SpecialCaveSpiderEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<WitchCaveSpiderEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDD0E0E).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(2).spitAttackMultiplied(0.1, 1.0, 2.0f, 1.0).addToAttribute(Attributes.f_22284_, 15.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Witch Cave Spider", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        WitchCaveSpiderEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.f_20495_.m_20677_());
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<WitchCaveSpiderEntity> getVariantFactory() {
        return WitchCaveSpiderEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends WitchCaveSpiderEntity> getSpecies() {
        return SPECIES;
    }

    public WitchCaveSpiderEntity(EntityType<? extends _SpecialCaveSpiderEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected int getVariantSpitColor() {
        return 7012387;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyWitchSpiderEffect(target, this.f_19796_, false);
        MobHelper.stealBuffEffect((LivingEntity)this, target);
    }

    @Override
    public boolean m_7301_(MobEffectInstance effect) {
        return effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL && super.m_7301_(effect);
    }
}

