/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

@SpecialMob
public class DarkCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DarkCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(16383802).uniqueTextureWithEyes().addExperience(1);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Dark Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DarkCreeperEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (ItemLike)Blocks.f_50081_);
        loot.addRareDrop("rare", PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43603_));
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<DarkCreeperEntity> getVariantFactory() {
        return DarkCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DarkCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DarkCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius / 2.0f);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Level x2;
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionPower, true, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        BlockPos center = BlockPos.m_274446_((Position)explosion.getPos());
        int radius = this.f_32272_ * 4 * (this.m_7090_() ? 2 : 1);
        for (int y = -radius; y <= radius; ++y) {
            for (int x2 = -radius; x2 <= radius; ++x2) {
                for (int z = -radius; z <= radius; ++z) {
                    if (x2 * x2 + y * y + z * z > radius * radius) continue;
                    BlockPos pos = center.m_7918_(x2, y, z);
                    BlockState block = this.m_9236_().m_8055_(pos);
                    if (block.getLightEmission((BlockGetter)this.m_9236_(), pos) <= 1 || explosion.getHitBlocks().contains(pos) || !explosion.tryExplodeBlock(pos, block, radius)) continue;
                    explosion.getHitBlocks().add(pos);
                }
            }
        }
        explosion.finalizeExplosion();
        if (this.m_7090_() && (x2 = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)x2;
            long time = serverLevel.m_46468_();
            int dayTime = (int)(time % 24000L);
            time += 13000L - (long)dayTime;
            if (dayTime > 13000) {
                time += 24000L;
            }
            serverLevel.m_8615_(time);
        }
    }

    @Override
    protected void modifyVariantLingeringCloudEffects(List<MobEffectInstance> potions) {
        potions.add(new MobEffectInstance(MobEffects.f_19610_, 100));
    }
}

