/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

@SpecialMob
public class DoomCreeperEntity
extends _SpecialCreeperEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DoomCreeperEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x494949).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithOverlay().addExperience(1).effectImmune(MobEffects.f_19602_, MobEffects.f_19615_);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Doom Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DoomCreeperEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.f_20495_.m_20677_());
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<DoomCreeperEntity> getVariantFactory() {
        return DoomCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DoomCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DoomCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius / 2.0f);
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        ExplosionHelper.explode((Entity)this, explosionPower, false, false);
    }

    @Override
    protected void modifyVariantLingeringCloudEffects(List<MobEffectInstance> potions) {
        potions.add(new MobEffectInstance(MobEffects.f_19602_, 100, 1));
        potions.add(new MobEffectInstance(MobEffects.f_19615_, 200));
    }

    @Override
    protected void modifyVariantLingeringCloud(AreaEffectCloud potionCloud) {
        potionCloud.m_19712_((float)this.f_32272_ * (this.m_7090_() ? 2.0f : 1.0f));
    }
}

