/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.creeper;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.value.EnvironmentEntry;
import fathertoast.crust.api.config.common.value.EnvironmentList;
import fathertoast.crust.api.config.common.value.environment.biome.BiomeCategory;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.block.UnderwaterSilverfishBlock;
import fathertoast.specialmobs.common.config.species.DrowningCreeperSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.AmphibiousMovementController;
import fathertoast.specialmobs.common.entity.ai.IAmphibiousMob;
import fathertoast.specialmobs.common.entity.ai.goal.AmphibiousGoToWaterGoal;
import fathertoast.specialmobs.common.entity.ai.goal.AmphibiousSwimUpGoal;
import fathertoast.specialmobs.common.entity.creeper._SpecialCreeperEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootEntryItemBuilder;
import fathertoast.specialmobs.datagen.loot.LootPoolBuilder;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.WaterBoundPathNavigation;
import net.minecraft.world.entity.animal.Pufferfish;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class DrowningCreeperEntity
extends _SpecialCreeperEntity
implements IAmphibiousMob {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DrowningCreeperEntity> SPECIES;
    private int pufferfish;
    private final WaterBoundPathNavigation waterNavigation;
    private final GroundPathNavigation groundNavigation;
    private boolean swimmingUp;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(2966004).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.WATER).uniqueTextureWithEyes().addExperience(2).drownImmune().fluidPushImmune().addToAttribute(Attributes.f_22276_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        SpeciesConfig.NEXT_NATURAL_SPAWN_CHANCE_EXCEPTIONS = new EnvironmentList(new EnvironmentEntry[]{EnvironmentEntry.builder((ConfigManager)manager, (float)0.06f).inBiome(Biomes.f_48166_).build(), EnvironmentEntry.builder((ConfigManager)manager, (float)0.06f).inBiomeCategory(BiomeCategory.RIVER).build(), EnvironmentEntry.builder((ConfigManager)manager, (float)0.02f).inBiomeCategory(BiomeCategory.OCEAN).belowSeaDepths().build(), EnvironmentEntry.builder((ConfigManager)manager, (float)0.0f).inBiomeCategory(BiomeCategory.OCEAN).build()});
        return new DrowningCreeperSpeciesConfig(manager, species, false, false, false, 0.25, 2, 4);
    }

    @Override
    public DrowningCreeperSpeciesConfig getConfig() {
        return (DrowningCreeperSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpeciesSpawnPlacement(MobFamily.Species<? extends DrowningCreeperEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, SpawnPlacements.Type.IN_WATER, DrowningCreeperEntity::checkSpeciesSpawnRules);
    }

    public static boolean checkSpeciesSpawnRules(EntityType<? extends DrowningCreeperEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        Holder biome = level.m_204166_(pos);
        if (biome.m_203656_(BiomeTags.f_207603_) || biome.m_203656_(BiomeTags.f_207605_)) {
            return NaturalSpawnManager.checkSpawnRulesWater(type, level, spawnType, pos, random);
        }
        return NaturalSpawnManager.checkSpawnRulesDefault(type, level, spawnType, pos, random);
    }

    public boolean m_6914_(LevelReader level) {
        return level.m_45784_((Entity)this);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Drowning Creeper", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DrowningCreeperEntity.addBaseLoot(loot);
        loot.addPool(new LootPoolBuilder("common").addEntry(new LootEntryItemBuilder((ItemLike)Items.f_42526_).setCount(0, 2).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
        loot.addPool(new LootPoolBuilder("semicommon").addEntry(new LootEntryItemBuilder((ItemLike)Items.f_42527_).setCount(0, 1).addLootingBonus(0.0f, 1.0f).smeltIfBurning().toLootEntry()).toLootPool());
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42587_, Items.f_42695_, Items.f_42696_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<DrowningCreeperEntity> getVariantFactory() {
        return DrowningCreeperEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DrowningCreeperEntity> getSpecies() {
        return SPECIES;
    }

    public DrowningCreeperEntity(EntityType<? extends _SpecialCreeperEntity> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new AmphibiousMovementController<DrowningCreeperEntity>(this);
        this.waterNavigation = new WaterBoundPathNavigation((Mob)this, level);
        this.groundNavigation = new GroundPathNavigation((Mob)this, level);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
        this.pufferfish = this.getConfig().DROWNING.puffPuffs.next(this.f_19796_);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.removeGoals(this.f_21345_, FloatGoal.class);
        AIHelper.insertGoal(this.f_21345_, 5, new AmphibiousGoToWaterGoal((Mob)this, 1.0).alwaysEnabled());
        AIHelper.insertGoal(this.f_21345_, 6, new AmphibiousSwimUpGoal<DrowningCreeperEntity>(this, 1.0));
        AIHelper.replaceWaterAvoidingRandomWalking((PathfinderMob)this, 0.8);
    }

    @Override
    protected float getVariantExplosionPower(float radius) {
        return super.getVariantExplosionPower(radius) + 3.0f;
    }

    @Override
    protected void makeVariantExplosion(float explosionPower) {
        Explosion.BlockInteraction explosionMode = ExplosionHelper.getMode((Entity)this);
        ExplosionHelper explosion = new ExplosionHelper((Entity)this, explosionMode == Explosion.BlockInteraction.KEEP ? explosionPower : 1.0f, explosionMode, false);
        if (!explosion.initializeExplosion()) {
            return;
        }
        explosion.finalizeExplosion();
        if (explosionMode == Explosion.BlockInteraction.KEEP) {
            return;
        }
        boolean ultrawarm = this.m_9236_().m_6042_().f_63857_();
        UnderwaterSilverfishBlock.Type mainType = UnderwaterSilverfishBlock.Type.next(this.f_19796_);
        UnderwaterSilverfishBlock.Type rareType = UnderwaterSilverfishBlock.Type.next(this.f_19796_);
        BlockState mainCoral = mainType.hostBlock().m_49966_();
        BlockState rareCoral = rareType.hostBlock().m_49966_();
        BlockState mainInfestedCoral = mainType.block().m_49966_();
        BlockState rareInfestedCoral = rareType.block().m_49966_();
        BlockState water = Blocks.f_49990_.m_49966_();
        BlockState seaPickle = (BlockState)Blocks.f_50567_.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        BlockState seaGrass = Blocks.f_50037_.m_49966_();
        int radius = (int)Math.floor(explosionPower);
        int radiusSq = radius * radius;
        int rMinusOneSq = (radius - 1) * (radius - 1);
        BlockPos center = BlockPos.m_274446_((Position)explosion.getPos());
        if (this.pufferfish > 0) {
            this.spawnPufferfish(center.m_6630_(1));
        }
        int pufferCount = 1;
        for (int y = -radius; y <= radius; ++y) {
            for (int x = -radius; x <= radius; ++x) {
                for (int z = -radius; z <= radius; ++z) {
                    int distSq = x * x + y * y + z * z;
                    if (distSq > radiusSq) continue;
                    BlockPos pos = center.m_7918_(x, y, z);
                    BlockState stateAtPos = this.m_9236_().m_8055_(pos);
                    if (!stateAtPos.m_247087_() && !stateAtPos.m_204336_(BlockTags.f_13035_)) continue;
                    if (distSq <= rMinusOneSq) {
                        float fillChoice = this.f_19796_.m_188501_();
                        if (ultrawarm) {
                            BlockState fire;
                            if (!(fillChoice < 0.3f) || !(fire = BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)pos)).m_60710_((LevelReader)this.m_9236_(), pos)) continue;
                            MobHelper.placeBlock((Entity)this, pos, fire);
                            continue;
                        }
                        if (fillChoice < 0.1f && seaPickle.m_60710_((LevelReader)this.m_9236_(), pos)) {
                            MobHelper.placeBlock((Entity)this, pos, seaPickle);
                            continue;
                        }
                        if (fillChoice < 0.3f && seaGrass.m_60710_((LevelReader)this.m_9236_(), pos)) {
                            MobHelper.placeBlock((Entity)this, pos, seaGrass);
                            continue;
                        }
                        MobHelper.placeBlock((Entity)this, pos, water);
                        if (!(this.f_19796_.m_188501_() < 0.0075f) || pufferCount >= this.pufferfish) continue;
                        this.spawnPufferfish(pos);
                        ++pufferCount;
                        continue;
                    }
                    if (!this.isCoralSafe(rMinusOneSq, x, y, z)) continue;
                    boolean infested = this.getConfig().DROWNING.infestedBlockChance.rollChance(this.f_19796_);
                    if (ultrawarm) {
                        MobHelper.placeBlock((Entity)this, pos, infested ? Blocks.f_50227_.m_49966_() : Blocks.f_50652_.m_49966_());
                        continue;
                    }
                    MobHelper.placeBlock((Entity)this, pos, this.f_19796_.m_188501_() < 0.8f ? (infested ? mainInfestedCoral : mainCoral) : (infested ? rareInfestedCoral : rareCoral));
                }
            }
        }
    }

    private void spawnPufferfish(BlockPos pos) {
        if (!(this.m_9236_() instanceof ServerLevelAccessor)) {
            return;
        }
        Pufferfish lePuffPuff = (Pufferfish)EntityType.f_20516_.m_20615_(this.m_9236_());
        if (lePuffPuff != null) {
            lePuffPuff.m_6034_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5);
            this.m_9236_().m_7967_((Entity)lePuffPuff);
        }
    }

    private boolean isCoralSafe(int rMinusOneSq, int x, int y, int z) {
        int innerZ;
        int innerX;
        int innerY;
        int distSq;
        if (y != 0 && (distSq = x * x + (innerY = y < 0 ? y + 1 : y - 1) * innerY + z * z) <= rMinusOneSq) {
            return true;
        }
        if (x != 0 && (distSq = (innerX = x < 0 ? x + 1 : x - 1) * innerX + y * y + z * z) <= rMinusOneSq) {
            return true;
        }
        return z != 0 && (distSq = x * x + y * y + (innerZ = z < 0 ? z + 1 : z - 1) * innerZ) <= rMinusOneSq;
    }

    public boolean m_20070_() {
        return true;
    }

    public boolean m_20071_() {
        return true;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Summons", (byte)this.pufferfish);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Summons", 99)) {
            this.pufferfish = saveTag.m_128445_("Summons");
        }
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_) {
            if (this.m_21515_() && this.m_5842_() && this.shouldSwim()) {
                this.setNavigatorToSwim();
                this.m_20282_(true);
            } else {
                this.setNavigatorToGround();
                this.m_20282_(false);
            }
        }
    }

    public void m_7023_(Vec3 input) {
        if (this.m_21515_() && this.m_5842_() && this.shouldSwim()) {
            this.m_19920_(0.01f, input);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.9));
        } else {
            super.m_7023_(input);
        }
    }

    protected float m_6108_() {
        return 0.9f;
    }

    @Override
    public boolean shouldSwim() {
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity target = this.m_5448_();
        return target != null && target.m_20069_();
    }

    @Override
    public void setSwimmingUp(boolean value) {
        this.swimmingUp = value;
    }

    @Override
    public boolean isSwimmingUp() {
        return this.swimmingUp;
    }

    @Override
    public void setNavigatorToSwim() {
        this.f_21344_ = this.waterNavigation;
    }

    @Override
    public void setNavigatorToGround() {
        this.f_21344_ = this.groundNavigation;
    }
}

