/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.block.MeltingIceBlock;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.drowned._SpecialDrownedEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;

@SpecialMob
public class FrozenDrownedEntity
extends _SpecialDrownedEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FrozenDrownedEntity> SPECIES;
    private static final int ICE_SEAL_TICKS = 4;
    private int iceSealTimer;
    private BlockPos iceSealPos;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.ICE).uniqueTextureWithOverlay().addExperience(2).effectImmune(MobEffects.f_19597_).addToAttribute(Attributes.f_22284_, 10.0).multiplyAttribute(Attributes.f_22279_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Frozen Drowned", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FrozenDrownedEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Blocks.f_50126_);
        loot.addRareDrop("rare", new ItemLike[]{Blocks.f_50568_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FrozenDrownedEntity> getVariantFactory() {
        return FrozenDrownedEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FrozenDrownedEntity> getSpecies() {
        return SPECIES;
    }

    public FrozenDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19597_, 2);
    }

    @Override
    protected ItemStack getTridentForRanged() {
        return MobHelper.tridentWithEffect(MobEffects.f_19597_, 2, MobHelper.defaultEffectDuration(this.m_9236_().m_46791_()));
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            BlockPos pos;
            LivingEntity target;
            if (this.iceSealPos != null) {
                if (this.iceSealTimer++ % 4 == 0) {
                    int radius = this.iceSealTimer / 4;
                    this.makeIceSeal(this.iceSealPos, radius);
                    if (radius >= 7) {
                        this.iceSealTimer = 100 + this.f_19796_.m_188503_(100);
                        this.iceSealPos = null;
                    }
                }
            } else if (this.iceSealTimer-- <= 0 && (target = this.m_5448_()) != null && target.m_5842_() && this.m_20280_((Entity)target) < 144.0 && this.f_19796_.m_188503_(20) == 0 && (pos = this.findIceSealPos(target.m_20183_(), Mth.m_14167_((float)target.m_20206_()))) != null && ExplosionHelper.getMode((Entity)this) != Explosion.BlockInteraction.KEEP) {
                this.iceSealTimer = 0;
                this.iceSealPos = pos;
            }
        }
        super.m_8107_();
    }

    @Nullable
    private BlockPos findIceSealPos(BlockPos targetPos, int targetHeight) {
        int maxRange = 6 + targetHeight;
        BlockPos.MutableBlockPos pos = targetPos.m_122032_();
        for (int y = 0; y <= maxRange; ++y) {
            pos.m_142448_(targetPos.m_123342_() + y);
            if (pos.m_123342_() >= this.m_9236_().m_151558_()) break;
            BlockState block = this.m_9236_().m_8055_((BlockPos)pos);
            if (block.m_60734_() == Blocks.f_49990_ && (Integer)block.m_61143_((Property)LiquidBlock.f_54688_) == 0) continue;
            if (y - 1 <= targetHeight) break;
            return pos.m_7495_();
        }
        return null;
    }

    private void makeIceSeal(BlockPos center, int radius) {
        if (!this.m_20067_()) {
            this.m_9236_().m_6263_(null, (double)center.m_123341_() + 0.5, (double)center.m_123342_() + 0.5, (double)center.m_123343_() + 0.5, SoundEvents.f_11983_, this.m_5720_(), 0.4f, 1.0f / (this.f_19796_.m_188501_() * 0.4f + 0.8f));
        }
        if (radius <= 0) {
            this.placeSealBlock(center);
            return;
        }
        for (int x = -radius; x <= radius; ++x) {
            for (int z = -radius; z <= radius; ++z) {
                int distSq = x * x + z * z;
                if (distSq > radius * radius) continue;
                this.placeSealBlock(center.m_7918_(x, 0, z));
            }
        }
    }

    private void placeSealBlock(BlockPos pos) {
        BlockState block = MeltingIceBlock.getState(this.m_9236_(), pos);
        if (this.m_9236_().m_8055_(pos).m_247087_() && this.m_9236_().m_45752_(block, pos, CollisionContext.m_82749_()) && MobHelper.placeBlock((Entity)this, pos, block)) {
            MeltingIceBlock.scheduleFirstTick(this.m_9236_(), pos, this.f_19796_);
        }
    }
}

