/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.drowned;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.DrownedSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialDrownedAttackGoal;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialHurtByTargetGoal;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialTridentAttackGoal;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class _SpecialDrownedEntity
extends Drowned
implements ISpecialMob<_SpecialDrownedEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialDrownedEntity> SPECIES;
    protected static final double DEFAULT_TRIDENT_CHANCE = 0.0625;
    protected static final double DEFAULT_SHIELD_CHANCE = 0.0625;
    private static final EntityDataAccessor<Float> SCALE;
    private boolean needsToBeDeeper;
    private SpecialMobData<_SpecialDrownedEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(7969893).modBaseTexture("textures/entity/drowned/base_drowned.png").modOverlayTexture("textures/entity/drowned/drowned_overlay.png").experience(5).undead().throwAttack(1.0, 1.0, 40, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new DrownedSpeciesConfig(manager, species, 0.0625, 0.0625);
    }

    public DrownedSpeciesConfig getConfig() {
        return (DrownedSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_34328_() {
        return Drowned.m_34328_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialDrownedEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, SpawnPlacements.Type.IN_WATER, _SpecialDrownedEntity::checkFamilySpawnRules);
    }

    public static boolean checkFamilySpawnRules(EntityType<? extends Drowned> type, ServerLevelAccessor world, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Drowned.m_218955_(type, (ServerLevelAccessor)world, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, world, spawnType, pos, random);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Drowned", "Ahogado", "Afogado", "Noy\u00e9", "Annegato", "Ertrunkener", "Sunken Sailor");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20562_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.DROWNED, EntityTypeTags.f_144292_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<_SpecialDrownedEntity> getFactory() {
        return _SpecialDrownedEntity::new;
    }

    protected void m_8099_() {
        super.m_8099_();
        AIHelper.removeGoals(this.f_21345_, 2);
        this.f_21345_.m_25352_(2, (Goal)new SpecialDrownedAttackGoal(this, 1.0, false));
        AIHelper.replaceHurtByTarget((PathfinderMob)this, new SpecialHurtByTargetGoal((PathfinderMob)this, Zombie.class, Drowned.class).setAlertOthers(ZombifiedPiglin.class));
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
    }

    public void m_19970_(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.m_19970_(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundTag saveTag) {
    }

    public void readVariantSaveData(CompoundTag saveTag) {
    }

    protected ItemStack getTridentForRanged() {
        return new ItemStack((ItemLike)Items.f_42713_);
    }

    public _SpecialDrownedEntity(EntityType<? extends _SpecialDrownedEntity> entityType, Level level) {
        super(entityType, level);
        this.recalculateAttackGoal();
        this.getSpecialData().initialize();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.specialData = new SpecialMobData<_SpecialDrownedEntity>(this, SCALE);
    }

    public void recalculateAttackGoal() {
        if (this.m_9236_() != null && !this.m_9236_().f_46443_) {
            AIHelper.removeGoals(this.f_21345_, SpecialTridentAttackGoal.class);
            if (this.getSpecialData().getRangedAttackMaxRange() > 0.0f) {
                this.f_21345_.m_25352_(2, (Goal)new SpecialTridentAttackGoal((RangedAttackMob)this, this.getSpecialData().getRangedWalkSpeed(), this.getSpecialData().getRangedAttackCooldown(), this.getSpecialData().getRangedAttackMaxRange()));
            }
        }
    }

    public void m_6504_(LivingEntity target, float damageMulti) {
        ThrownTrident trident = new ThrownTrident(this.m_9236_(), (LivingEntity)this, this.getTridentForRanged());
        double dX = target.m_20185_() - this.m_20185_();
        double dY = target.m_20227_(0.3333) - trident.m_20186_();
        double dZ = target.m_20189_() - this.m_20189_();
        double dH = Mth.m_14116_((float)((float)(dX * dX + dZ * dZ)));
        trident.m_6686_(dX, dY + dH * 0.2, dZ, 1.6f, this.getSpecialData().getRangedAttackSpread() * (float)(14 - this.m_9236_().m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_11821_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)trident);
    }

    public void m_5844_() {
        if (!this.m_9236_().f_46443_ && this.m_21515_()) {
            this.needsToBeDeeper = true;
        }
        super.m_5844_();
    }

    public void m_7023_(Vec3 input) {
        if (this.m_21515_()) {
            this.needsToBeDeeper = true;
        }
        super.m_7023_(input);
    }

    public boolean m_20069_() {
        if (this.needsToBeDeeper) {
            this.needsToBeDeeper = false;
            return this.m_5842_();
        }
        return super.m_20069_();
    }

    protected float m_6108_() {
        return 0.9f;
    }

    @Override
    public SpecialMobData<_SpecialDrownedEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialDrownedEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.f_21364_;
    }

    @Override
    public final void setExperience(int xp) {
        this.f_21364_ = xp;
    }

    @Override
    public void setSpecialPathfindingMalus(BlockPathTypes types, float malus) {
        this.m_21441_(types, malus);
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> entityType, boolean keepEquipment) {
        Level level;
        Mob replacement = super.m_21406_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            MobHelper.finalizeSpawn((LivingEntity)replacement, serverLevel, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, level, difficulty, spawnType, super.m_6518_(level, difficulty, spawnType, groupData, eggTag));
    }

    protected final void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        ItemStack heldItem = this.m_6844_(EquipmentSlot.MAINHAND);
        if (heldItem.m_41619_() || heldItem.m_41720_() == Items.f_42713_ || heldItem.m_41720_() == Items.f_42523_) {
            double heldItemChoice = this.f_19796_.m_188500_();
            if (this.getSpecialData().getRangedAttackMaxRange() > 0.0f && heldItemChoice < this.getConfig().DROWNED.tridentEquipChance.get()) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42713_));
            } else if (heldItemChoice >= 0.9625) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42523_));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
            }
        }
        if (this.getConfig().DROWNED.shieldEquipChance.rollChance(this.f_19796_)) {
            this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)Items.f_42740_));
        }
        this.finalizeVariantSpawn(level, difficulty, spawnType, groupData);
    }

    public void m_8107_() {
        super.m_8107_();
        this.getSpecialData().tick();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return super.m_6431_(pose, size) * this.getSpecialData().getHeightScale();
    }

    public boolean m_5825_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void m_7311_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.m_7311_(ticks);
        }
    }

    protected boolean m_5884_() {
        return !this.getSpecialData().isImmuneToFire() && !this.getSpecialData().isImmuneToBurning();
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getSpecialData().allowLeashing();
    }

    public void m_7601_(BlockState block, Vec3 speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.m_7601_(block, speedMulti);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier(), damageSource);
    }

    public boolean m_6090_() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean m_6040_() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean m_6063_() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean m_6126_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Entity entity = source.m_7640_();
        if (this.m_6126_() && entity instanceof Snowball) {
            amount = Math.max(3.0f, amount);
        }
        if (amount > 0.0f && MobHelper.tryBlockAttack((LivingEntity)this, source, true)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
        this.recalculateAttackGoal();
    }

    static {
        SCALE = SynchedEntityData.m_135353_(_SpecialDrownedEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

