/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class BlindingEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<BlindingEndermanEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xFFFFFF).theme(BestiaryInfo.Theme.FOREST).uniqueTextureWithEyes().addExperience(1).effectImmune(MobEffects.f_19610_);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Blinding Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        BlindingEndermanEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42532_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<BlindingEndermanEntity> getVariantFactory() {
        return BlindingEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends BlindingEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public BlindingEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        LivingEntity target = this.m_5448_();
        if (target != null && this.m_20280_((Entity)target) < 100.0) {
            MobHelper.applyDurationEffect(target, MobEffects.f_19610_, 50);
            MobHelper.removeNightVision(target);
        }
    }
}

