/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.ExplosionHelper;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;

@SpecialMob
public class FlameEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FlameEndermanEntity> SPECIES;
    private int flameRingCooldown;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14424576).theme(BestiaryInfo.Theme.FIRE).uniqueTextureWithEyes().addExperience(2).fireImmune().addToAttribute(Attributes.f_22276_, 10.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Flame Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FlameEndermanEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42613_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42413_});
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.ENDERMEN, EntityTypeTags.f_144295_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FlameEndermanEntity> getVariantFactory() {
        return FlameEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FlameEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public FlameEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    public void m_8107_() {
        --this.flameRingCooldown;
        super.m_8107_();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.m_20254_(4);
        for (int i = 0; i < 64 && !this.m_32529_(); ++i) {
        }
    }

    protected boolean m_32500_(Entity target) {
        if (super.m_32500_(target)) {
            if (this.flameRingCooldown <= 0) {
                this.flameRingCooldown = 100 + this.f_19796_.m_188503_(100);
                this.makeFireRing(target.m_20183_());
            }
            return true;
        }
        return false;
    }

    private void makeFireRing(BlockPos center) {
        if (ExplosionHelper.getMode((Entity)this) == Explosion.BlockInteraction.KEEP) {
            return;
        }
        int radius = 5;
        int rMinusOneSq = 16;
        for (int x = -5; x <= 5; ++x) {
            for (int z = -5; z <= 5; ++z) {
                int distSq = x * x + z * z;
                if (distSq > 25 || distSq <= 16) continue;
                this.placeFireWall(center.m_7918_(x, 0, z), 5);
            }
        }
    }

    private void placeFireWall(BlockPos pos, int radius) {
        BlockPos.MutableBlockPos currentPos = pos.m_122032_();
        currentPos.m_142448_(Math.max(pos.m_123342_() - radius, 0));
        int maxY = Math.min(pos.m_123342_() + radius, this.m_9236_().m_151558_() - 2);
        while (currentPos.m_123342_() < maxY) {
            currentPos.m_122184_(0, 1, 0);
            if (!this.shouldSetFire((BlockPos)currentPos)) continue;
            MobHelper.placeBlock((Entity)this, (BlockPos)currentPos, BaseFireBlock.m_49245_((BlockGetter)this.m_9236_(), (BlockPos)currentPos));
        }
    }

    private boolean shouldSetFire(BlockPos pos) {
        if (!this.m_9236_().m_8055_(pos).m_247087_()) {
            return false;
        }
        if (((FireBlock)Blocks.f_50083_).canCatchFire((BlockGetter)this.m_9236_(), pos, Direction.UP)) {
            return true;
        }
        BlockPos posBelow = pos.m_7495_();
        return this.m_9236_().m_8055_(posBelow).m_60783_((BlockGetter)this.m_9236_(), posBelow, Direction.UP);
    }
}

