/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.FluidPathNavigator;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;

@SpecialMob
public class IcyEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<IcyEndermanEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).theme(BestiaryInfo.Theme.ICE).uniqueTextureWithEyes().addExperience(1).effectImmune(MobEffects.f_19597_);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Icy Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        IcyEndermanEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (ItemLike)Items.f_42452_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50568_});
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.ENDERMEN, EntityTypeTags.f_144294_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<IcyEndermanEntity> getVariantFactory() {
        return IcyEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends IcyEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public IcyEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, Level level) {
        super(entityType, level);
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19597_, 5, 0.5f);
        MobHelper.applyEffect(target, MobEffects.f_19599_, 3);
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.replaceWaterAvoidingRandomWalking((PathfinderMob)this, 1.0);
    }

    protected PathNavigation m_6037_(Level level) {
        return new FluidPathNavigator((Mob)this, level, true, false);
    }

    public boolean m_203441_(FluidState fluid) {
        return fluid.m_205070_(FluidTags.f_13131_);
    }

    protected void m_5806_(BlockPos pos) {
        super.m_5806_(pos);
        this.updateFrostWalker(pos);
    }

    protected boolean m_32543_(double x, double y, double z) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        while (pos.m_123342_() > 0) {
            BlockState block = this.m_9236_().m_8055_((BlockPos)pos);
            if (block.m_280555_() || block.m_60819_().m_205070_(FluidTags.f_13131_)) {
                EntityTeleportEvent.EnderEntity event = ForgeEventFactory.onEnderTeleport((LivingEntity)this, (double)x, (double)(y + 1.0), (double)z);
                if (event.isCanceled()) {
                    return false;
                }
                boolean success = this.uncheckedTeleport(event.getTargetX(), event.getTargetY(), event.getTargetZ(), true);
                if (success) {
                    this.updateFrostWalker(pos.m_7949_().m_7494_());
                    if (!this.m_20067_()) {
                        this.m_9236_().m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, SoundEvents.f_11852_, this.m_5720_(), 1.0f, 1.0f);
                        this.m_5496_(SoundEvents.f_11852_, 1.0f, 1.0f);
                    }
                }
                return success;
            }
            pos.m_122173_(Direction.DOWN);
            y -= 1.0;
        }
        return false;
    }

    private boolean uncheckedTeleport(double x, double y, double z, boolean spawnParticles) {
        if (this.m_20159_()) {
            return false;
        }
        double xI = this.m_20185_();
        double yI = this.m_20186_();
        double zI = this.m_20189_();
        if (this.m_9236_().m_46805_(BlockPos.m_274561_((double)x, (double)y, (double)z))) {
            this.m_6021_(x, y, z);
            if (this.m_9236_().m_45786_((Entity)this) && !this.m_9236_().m_46855_(this.m_20191_())) {
                if (spawnParticles) {
                    References.EntityEvent.TELEPORT_TRAIL_PARTICLES.broadcast((LivingEntity)this);
                }
                this.m_21573_().m_26573_();
                return true;
            }
        }
        this.m_6021_(xI, yI, zI);
        return false;
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        this.m_21441_(BlockPathTypes.WATER, BlockPathTypes.WALKABLE.m_77124_());
    }

    private void updateFrostWalker(BlockPos pos) {
        boolean actualOnGround = this.m_20096_();
        this.m_6853_(true);
        FrostWalkerEnchantment.m_45018_((LivingEntity)this, (Level)this.m_9236_(), (BlockPos)pos, (int)1);
        this.m_6853_(actualOnGround);
    }
}

