/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;

@SpecialMob
public class MirageEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<MirageEndermanEntity> SPECIES;
    public boolean isFake = false;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(12762244).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.DESERT).uniqueTextureWithEyes().addExperience(2).addToAttribute(Attributes.f_22276_, 20.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Mirage Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        MirageEndermanEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (ItemLike)Blocks.f_49992_, 1);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Blocks.f_50226_, Blocks.f_50227_, Blocks.f_50176_, Blocks.f_50178_, Blocks.f_50177_, Blocks.f_50179_});
        loot.addRareDrop("rare", new ItemLike[]{Items.f_42417_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<MirageEndermanEntity> getVariantFactory() {
        return MirageEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends MirageEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public MirageEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, Level level) {
        super(entityType, level);
    }

    public void setFake() {
        this.isFake = true;
        this.setExperience(0);
        this.m_21051_(Attributes.f_22281_).m_22100_(0.0);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        for (int i = 0; i < 64 && !this.m_32529_(); ++i) {
        }
    }

    public void m_8119_() {
        if (this.isFake && this.f_19797_ >= 200) {
            this.m_21373_();
            this.m_146870_();
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.isFake) {
            this.m_21153_(0.0f);
            return true;
        }
        return super.m_6469_(source, amount);
    }

    protected boolean m_32543_(double x, double y, double z) {
        if (this.isFake) {
            return false;
        }
        if (super.m_32543_(x, y, z)) {
            this.mirage();
            return true;
        }
        return false;
    }

    private void mirage() {
        if (!this.isFake && this.m_5448_() != null) {
            MirageEndermanEntity mirage = (MirageEndermanEntity)((EntityType)MirageEndermanEntity.SPECIES.entityType.get()).m_20615_(this.m_9236_());
            if (mirage == null) {
                return;
            }
            mirage.setFake();
            mirage.m_20359_((Entity)this);
            mirage.m_6710_(this.m_5448_());
            if (this.f_19796_.m_188503_(4) == 0) {
                this.m_6027_(this.f_19854_, this.f_19855_, this.f_19856_);
            } else {
                mirage.m_6027_(this.f_19854_, this.f_19855_, this.f_19856_);
            }
            mirage.m_21153_(this.m_21223_());
            this.m_9236_().m_7967_((Entity)mirage);
        }
    }

    protected void m_7625_(DamageSource source, boolean killedByPlayer) {
        if (!this.isFake) {
            super.m_7625_(source, killedByPlayer);
        }
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128379_("IsFake", this.isFake);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("IsFake", 99)) {
            this.isFake = saveTag.m_128471_("IsFake");
        }
    }
}

