/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.RunicEndermanBeamAttackGoal;
import fathertoast.specialmobs.common.entity.enderman._SpecialEndermanEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;

@SpecialMob
public class RunicEndermanEntity
extends _SpecialEndermanEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<RunicEndermanEntity> SPECIES;
    public static final double BEAM_MAX_RANGE = 32.0;
    private static final EntityDataAccessor<Byte> BEAM_STATE;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14951041).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.MOUNTAIN).uniqueTextureWithEyes().addExperience(2).fallImmune().burnImmune().convertRangedAttackToBeam(2.0, 1.0, 60, 100, 16.0).addToAttribute(Attributes.f_22284_, 10.0).addToAttribute(Attributes.f_22281_, 1.0).multiplyAttribute(Attributes.f_22279_, 0.8);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Runic Enderman", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        RunicEndermanEntity.addBaseLoot(loot);
        loot.addClusterDrop("common", (ItemLike)Blocks.f_50069_);
        loot.addRareDrop("rare", new ItemLike[]{Items.f_42729_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<RunicEndermanEntity> getVariantFactory() {
        return RunicEndermanEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends RunicEndermanEntity> getSpecies() {
        return SPECIES;
    }

    public RunicEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BEAM_STATE, (Object)BeamState.OFF.id());
    }

    @Override
    protected void registerVariantGoals() {
        AIHelper.insertGoal(this.f_21345_, 2, new RunicEndermanBeamAttackGoal(this));
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19620_);
        MobHelper.knockback((Entity)this, target, 2.0f, 0.0f);
    }

    public BeamState getBeamState() {
        return BeamState.of((Byte)this.f_19804_.m_135370_(BEAM_STATE));
    }

    public void setBeamState(BeamState value) {
        this.f_19804_.m_135381_(BEAM_STATE, (Object)value.id());
    }

    public AABB m_6921_() {
        return this.getBeamState() == BeamState.OFF ? super.m_6921_() : super.m_6921_().m_82369_(this.m_20252_(1.0f).m_82490_(32.0));
    }

    static {
        BEAM_STATE = SynchedEntityData.m_135353_(RunicEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    }

    public static enum BeamState {
        OFF,
        CHARGING,
        DAMAGING;


        public byte id() {
            return (byte)this.ordinal();
        }

        public static BeamState of(byte id) {
            return BeamState.values()[id];
        }
    }
}

