/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.enderman;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class _SpecialEndermanEntity
extends EnderMan
implements ISpecialMob<_SpecialEndermanEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialEndermanEntity> SPECIES;
    private static final EntityDataAccessor<Float> SCALE;
    private SpecialMobData<_SpecialEndermanEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0).modBaseTexture("textures/entity/enderman/base_enderman.png").modEyesTexture("textures/entity/enderman/base_enderman_eyes.png").experience(5).waterSensitive();
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_32541_() {
        return EnderMan.m_32541_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialEndermanEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Enderman", "Enderman", "Enderman", "Enderman", "Enderman", "Enderman", "Enderman");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20566_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return Collections.singletonList(SMTags.EntityTypes.ENDERMEN);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<_SpecialEndermanEntity> getFactory() {
        return _SpecialEndermanEntity::new;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
    }

    public void m_19970_(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.m_19970_(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundTag saveTag) {
    }

    public void readVariantSaveData(CompoundTag saveTag) {
    }

    public _SpecialEndermanEntity(EntityType<? extends _SpecialEndermanEntity> entityType, Level level) {
        super(entityType, level);
        this.getSpecialData().initialize();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.specialData = new SpecialMobData<_SpecialEndermanEntity>(this, SCALE);
    }

    @Override
    public SpecialMobData<_SpecialEndermanEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialEndermanEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.f_21364_;
    }

    @Override
    public final void setExperience(int xp) {
        this.f_21364_ = xp;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> entityType, boolean keepEquipment) {
        Level level;
        Mob replacement = super.m_21406_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            MobHelper.finalizeSpawn((LivingEntity)replacement, serverLevel, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, level, difficulty, spawnType, super.m_6518_(level, difficulty, spawnType, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(BlockPathTypes type, float malus) {
        this.m_21441_(type, malus);
    }

    protected final void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        this.finalizeVariantSpawn(level, difficulty, spawnType, groupData);
    }

    public void m_8107_() {
        super.m_8107_();
        this.getSpecialData().tick();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return super.m_6431_(pose, size) * this.getSpecialData().getHeightScaleByAge();
    }

    public boolean m_5825_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void m_7311_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.m_7311_(ticks);
        }
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getSpecialData().allowLeashing();
    }

    public void m_7601_(BlockState block, Vec3 speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.m_7601_(block, speedMulti);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier(), damageSource);
    }

    public boolean m_6090_() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean m_6040_() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean m_6063_() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean m_6126_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
    }

    static {
        SCALE = SynchedEntityData.m_135353_(_SpecialEndermanEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

