/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ghast;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.CorporealShiftGhastSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.entity.projectile.IncorporealFireballEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class CorporealShiftGhastEntity
extends _SpecialGhastEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<CorporealShiftGhastEntity> SPECIES;
    public static final EntityDataAccessor<Boolean> CORPOREAL;
    private int shiftTime;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(11009947).weight(BestiaryInfo.DefaultWeight.LOW).uniqueTextureWithAnimation().addExperience(4).regen(80).addToAttribute(Attributes.f_22276_, 20.0).multiplyAttribute(Attributes.f_22279_, 0.8);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new CorporealShiftGhastSpeciesConfig(manager, species, 300, 200);
    }

    public CorporealShiftGhastSpeciesConfig getConfig() {
        return (CorporealShiftGhastSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Corporeal Shift Ghast", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        CorporealShiftGhastEntity.addBaseLoot(loot);
        loot.addClusterDrop("cluster", (ItemLike)SMItems.INCORPOREAL_FIREBALL.get());
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<CorporealShiftGhastEntity> getVariantFactory() {
        return CorporealShiftGhastEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends CorporealShiftGhastEntity> getSpecies() {
        return SPECIES;
    }

    public CorporealShiftGhastEntity(EntityType<? extends _SpecialGhastEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CORPOREAL, (Object)false);
        if (!this.m_9236_().m_5776_()) {
            this.setCorporeal(this.f_19796_.m_188499_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (--this.shiftTime <= 0 && !this.m_9236_().m_5776_()) {
            this.setCorporeal(!this.isCorporeal());
            this.spawnShiftSmoke((ServerLevel)this.m_9236_());
        }
    }

    private void spawnShiftSmoke(ServerLevel world) {
        world.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 25, 0.0, 0.0, 0.0, 0.4);
    }

    public boolean m_6094_() {
        return this.isCorporeal() && super.m_6094_();
    }

    protected void m_7324_(Entity entity) {
        if (this.isCorporeal()) {
            super.m_7324_(entity);
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float amount) {
        if (!this.isCorporeal()) {
            return source.m_269533_(DamageTypeTags.f_268738_) && super.m_6469_(source, amount);
        }
        return super.m_6469_(source, amount);
    }

    public boolean isCorporeal() {
        return (Boolean)this.f_19804_.m_135370_(CORPOREAL);
    }

    private void setCorporeal(boolean value) {
        this.f_19804_.m_135381_(CORPOREAL, (Object)value);
        this.shiftTime = value ? this.getConfig().CORPOREAL_SHIFT.corporealTicks.get() : this.getConfig().CORPOREAL_SHIFT.incorporealTicks.get();
    }

    @Override
    public void m_6504_(LivingEntity target, float damageMulti) {
        if (this.isCorporeal()) {
            super.m_6504_(target, damageMulti);
            return;
        }
        References.LevelEvent.GHAST_SHOOT.play((Entity)this);
        float accelVariance = Mth.m_14116_((float)this.m_20270_((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        Vec3 lookVec = this.m_20252_(1.0f).m_82490_((double)this.m_20205_());
        double dX = target.m_20185_() - (this.m_20185_() + lookVec.f_82479_) + this.m_217043_().m_188583_() * (double)accelVariance;
        double dY = target.m_20227_(0.5) - (0.5 + this.m_20227_(0.5));
        double dZ = target.m_20189_() - (this.m_20189_() + lookVec.f_82481_) + this.m_217043_().m_188583_() * (double)accelVariance;
        IncorporealFireballEntity fireball = new IncorporealFireballEntity(this.m_9236_(), this, dX, dY, dZ);
        fireball.explosionPower = this.getVariantExplosionPower(this.m_32751_());
        fireball.m_6034_(this.m_20185_() + lookVec.f_82479_, this.m_20227_(0.5) + 0.5, this.m_20189_() + lookVec.f_82481_);
        this.m_9236_().m_7967_((Entity)fireball);
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128379_("IsShifted", this.isCorporeal());
        saveTag.m_128376_("ShiftTime", (short)this.shiftTime);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("IsShifted", 99)) {
            this.setCorporeal(saveTag.m_128471_("IsShifted"));
        }
        if (saveTag.m_128425_("ShiftTime", 99)) {
            this.shiftTime = saveTag.m_128448_("ShiftTime");
        }
    }

    static {
        CORPOREAL = SynchedEntityData.m_135353_(CorporealShiftGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    }
}

