/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.ghast;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.entity.ghast._SpecialGhastEntity;
import fathertoast.specialmobs.common.entity.projectile.SlabFireballEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SlabGhastEntity
extends _SpecialGhastEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<SlabGhastEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xCECECE).uniqueTextureWithAnimation().weight(BestiaryInfo.DefaultWeight.LOWEST).size(1.0f, 4.0f, 2.0f).addExperience(2).fireballAttack(0.0, 20, 20, 64.0).addToAttribute(Attributes.f_22276_, 5.0).addToAttribute(Attributes.f_22281_, 4.0).multiplyAttribute(Attributes.f_22279_, 1.5);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Slab Ghast", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        SlabGhastEntity.addBaseLoot(loot);
        loot.addSemicommonDrop("semicommon", (ItemLike)SMItems.SLAB_FIREBALL.get());
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_41931_});
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<SlabGhastEntity> getVariantFactory() {
        return SlabGhastEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends SlabGhastEntity> getSpecies() {
        return SPECIES;
    }

    public SlabGhastEntity(EntityType<? extends _SpecialGhastEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected int getVariantExplosionPower(int radius) {
        return Math.round((float)radius * 0.5f);
    }

    @Override
    public void m_6504_(LivingEntity target, float damageMulti) {
        References.LevelEvent.GHAST_SHOOT.play((Entity)this);
        float accelVariance = Mth.m_14116_((float)this.m_20270_((Entity)target)) * 0.5f * this.getSpecialData().getRangedAttackSpread();
        Vec3 lookVec = this.m_20252_(1.0f).m_82490_((double)this.m_20205_());
        double dX = target.m_20185_() - (this.m_20185_() + lookVec.f_82479_) + this.m_217043_().m_188583_() * (double)accelVariance;
        double dY = target.m_20227_(0.5) - (0.5 + this.m_20227_(0.5));
        double dZ = target.m_20189_() - (this.m_20189_() + lookVec.f_82481_) + this.m_217043_().m_188583_() * (double)accelVariance;
        SlabFireballEntity fireball = new SlabFireballEntity(this.m_9236_(), (LivingEntity)this, dX, dY, dZ);
        fireball.explosionPower = this.getVariantExplosionPower(this.m_32751_());
        fireball.m_6034_(this.m_20185_() + lookVec.f_82479_, this.m_20227_(0.5) + 0.5, this.m_20189_() + lookVec.f_82481_);
        this.m_9236_().m_7967_((Entity)fireball);
    }
}

