/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.projectile;

import fathertoast.specialmobs.common.core.SpecialMobs;
import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class BugSpitEntity
extends Projectile {
    private static final float DRAG_FACTOR = 0.99f;
    private static final float GRAVITY_ACCEL = 0.06f;
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.m_135353_(BugSpitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float damageAmount = 2.0f;
    private int knockback;

    public BugSpitEntity(EntityType<? extends BugSpitEntity> entityType, Level level) {
        super(entityType, level);
    }

    public BugSpitEntity(LivingEntity shooter, LivingEntity target) {
        super((EntityType)SMEntities.BUG_SPIT.get(), shooter.m_9236_());
        this.m_5602_((Entity)shooter);
        Vec3 lookVec = shooter.m_20252_(1.0f).m_82490_((double)shooter.m_20205_());
        this.m_6034_(shooter.m_20185_() + lookVec.f_82479_, shooter.m_20188_() - 0.1, shooter.m_20189_() + lookVec.f_82481_);
        float spread = 14 - 4 * this.m_9236_().m_46791_().m_19028_();
        if (shooter instanceof ISpecialMob) {
            ISpecialMob specialShooter = (ISpecialMob)shooter;
            this.setDamage(specialShooter.getSpecialData().getRangedAttackDamage());
            if (this.getDamage() < 0.0f) {
                SpecialMobs.LOG.warn("Entity is shooting damaging projectile, but has no ranged damage stat! {}", (Object)shooter);
                this.setDamage(2.0f);
            }
            if (specialShooter.getSpecialData().getRangedAttackSpread() >= 0.0f) {
                spread *= specialShooter.getSpecialData().getRangedAttackSpread();
            } else {
                SpecialMobs.LOG.warn("Entity is shooting projectile, but has no ranged spread stat! {}", (Object)shooter);
            }
        }
        double dX = target.m_20185_() - this.m_20185_();
        double dY = target.m_20227_(0.3333) - this.m_20186_();
        double dZ = target.m_20189_() - this.m_20189_();
        double dH = Mth.m_14116_((float)((float)(dX * dX + dZ * dZ)));
        this.m_6686_(dX, dY + dH * 0.2, dZ, 1.2f, spread);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOR, (Object)0xFFFFFF);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setColor(int color) {
        this.f_19804_.m_135381_(COLOR, (Object)color);
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(COLOR);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.m_9236_() != null && this.m_9236_().m_5776_()) {
            Vec3 v = this.m_20184_();
            for (int i = 0; i < 7; ++i) {
                double multi = 0.4 + 0.1 * (double)i;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123764_, this.m_20185_(), this.m_20186_(), this.m_20189_(), v.f_82479_ * multi, v.f_82480_ * multi, v.f_82481_ * multi);
            }
        }
    }

    public void setDamage(float amount) {
        this.damageAmount = amount;
    }

    public float getDamage() {
        return this.damageAmount;
    }

    public void setKnockback(int amount) {
        this.knockback = amount;
    }

    public int getKnockback() {
        return this.knockback;
    }

    public void m_8119_() {
        super.m_8119_();
        Vec3 v = this.m_20184_();
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitResult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.m_6532_(hitResult);
        }
        double nextX = this.m_20185_() + v.f_82479_;
        double nextY = this.m_20186_() + v.f_82480_;
        double nextZ = this.m_20189_() + v.f_82481_;
        this.m_37283_();
        if (this.m_9236_().m_45556_(this.m_20191_()).noneMatch(BlockBehaviour.BlockStateBase::m_60795_) || this.m_20072_()) {
            this.m_146870_();
        } else {
            this.m_20256_(v.m_82490_((double)0.99f));
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, (double)-0.06f, 0.0));
            }
            this.m_6034_(nextX, nextY, nextZ);
        }
    }

    protected void m_6532_(HitResult hit) {
        super.m_6532_(hit);
        if (!this.m_9236_().m_5776_()) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult hit) {
        super.m_5790_(hit);
        Entity target = hit.m_82443_();
        Entity owner = this.m_19749_();
        if (owner instanceof LivingEntity && target.m_6469_(this.m_269291_().m_269299_((Entity)this, (LivingEntity)owner), this.getDamage())) {
            if (this.getKnockback() > 0 && target instanceof LivingEntity) {
                MobHelper.knockback((Entity)this, (LivingEntity)target, (float)this.getKnockback(), 1.0f);
            }
            owner.m_19970_((LivingEntity)owner, target);
            ((LivingEntity)owner).m_21335_(target);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("RangedDamage", this.getDamage());
        tag.m_128405_("Knockback", this.getKnockback());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128425_("RangedDamage", 99)) {
            this.setDamage(tag.m_128457_("RangedDamage"));
        }
        if (tag.m_128425_("Knockback", 99)) {
            this.setKnockback(tag.m_128451_("Knockback"));
        }
    }
}

