/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.projectile;

import fathertoast.specialmobs.common.core.register.SMEntities;
import fathertoast.specialmobs.common.core.register.SMItems;
import fathertoast.specialmobs.common.entity.ghast.CorporealShiftGhastEntity;
import fathertoast.specialmobs.common.event.PlayerVelocityWatcher;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;

public class IncorporealFireballEntity
extends AbstractHurtingProjectile
implements IEntityAdditionalSpawnData,
ItemSupplier {
    public int explosionPower = 1;
    private boolean shouldExplode = false;
    @Nullable
    private LivingEntity target;

    public IncorporealFireballEntity(EntityType<? extends AbstractHurtingProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public IncorporealFireballEntity(Level level, CorporealShiftGhastEntity ghast, double x, double y, double z) {
        super((EntityType)SMEntities.INCORPOREAL_FIREBALL.get(), (LivingEntity)ghast, x, y, z, level);
        this.explosionPower = ghast.m_32751_();
        this.target = ghast.m_5448_();
    }

    public IncorporealFireballEntity(Level level, @Nullable Player owner, @Nullable LivingEntity target, double x, double y, double z) {
        this((EntityType<? extends AbstractHurtingProjectile>)((EntityType)SMEntities.INCORPOREAL_FIREBALL.get()), level);
        this.m_6034_(x, y, z);
        this.target = target;
        this.m_7678_(x, y, z, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d = Mth.m_14116_((float)((float)(x * x + y * y + z * z)));
        if (d != 0.0) {
            this.f_36813_ = x / d * 0.1;
            this.f_36814_ = y / d * 0.1;
            this.f_36815_ = z / d * 0.1;
        }
        if (owner != null) {
            this.m_5602_((Entity)owner);
            this.m_19915_(owner.m_146908_(), owner.m_146909_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.target == null || !this.target.m_6084_()) {
            this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            if (!this.m_9236_().f_46443_) {
                this.m_146870_();
            }
            return;
        }
        Vec3 vec3 = new Vec3(this.target.m_20185_() - this.m_20185_(), this.target.m_20186_() + (double)(this.target.m_20192_() / 2.0f) - this.m_20186_(), this.target.m_20189_() - this.m_20189_());
        this.m_20256_(vec3.m_82541_().m_82490_(0.5));
        if (!this.m_9236_().f_46443_ && this.shouldExplode) {
            this.explode();
        }
    }

    private void explode() {
        boolean mobGrief = ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this.m_19749_());
        Level.ExplosionInteraction mode = mobGrief ? Level.ExplosionInteraction.MOB : Level.ExplosionInteraction.NONE;
        this.m_9236_().m_255391_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (float)this.explosionPower, mobGrief, mode);
        this.target = null;
        this.m_146870_();
    }

    protected boolean m_5931_() {
        return false;
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
    }

    protected void m_5790_(EntityHitResult hitResult) {
        super.m_5790_(hitResult);
        if (!this.m_9236_().f_46443_) {
            Entity target = hitResult.m_82443_();
            if (target instanceof Player) {
                Player player = (Player)target;
                if (PlayerVelocityWatcher.get(player).isMoving()) {
                    this.explode();
                    return;
                }
            } else if (target.m_20185_() != target.f_19854_ || target.m_20186_() != target.f_19855_ || target.m_20189_() != target.f_19856_) {
                this.explode();
                return;
            }
            this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            this.m_146870_();
        }
    }

    public boolean m_6469_(DamageSource damageSource, float damage) {
        if (this.m_6673_(damageSource) || damageSource.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        this.shouldExplode = true;
        return true;
    }

    public ItemStack m_7846_() {
        return new ItemStack((ItemLike)SMItems.INCORPOREAL_FIREBALL.get());
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("ExplosionPower", this.explosionPower);
        compoundTag.m_128405_("TargetId", this.target == null ? -1 : this.target.m_19879_());
    }

    public void m_7378_(CompoundTag compoundTag) {
        Entity entity;
        super.m_7378_(compoundTag);
        if (compoundTag.m_128425_("ExplosionPower", 99)) {
            this.explosionPower = compoundTag.m_128451_("ExplosionPower");
        }
        if (compoundTag.m_128425_("TargetId", 99) && (entity = this.m_9236_().m_6815_(compoundTag.m_128451_("TargetId"))) instanceof LivingEntity) {
            this.target = (LivingEntity)entity;
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        Entity owner = this.m_19749_();
        buffer.writeInt(owner == null ? 0 : owner.m_19879_());
        buffer.writeInt(this.target == null ? 0 : this.target.m_19879_());
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
        int ownerId = additionalData.readInt();
        int targetId = additionalData.readInt();
        this.m_5602_(this.m_9236_().m_6815_(ownerId));
        if (this.m_9236_().m_6815_(targetId) instanceof LivingEntity) {
            this.target = (LivingEntity)this.m_9236_().m_6815_(targetId);
        }
    }
}

