/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.silverfish;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.SilverfishSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.silverfish._SpecialSilverfishEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class AlbinoSilverfishEntity
extends _SpecialSilverfishEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<AlbinoSilverfishEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xFFFFFF).theme(BestiaryInfo.Theme.ICE).uniqueTextureBaseOnly().addExperience(1).effectImmune(MobEffects.f_19597_).addToAttribute(Attributes.f_22284_, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SilverfishSpeciesConfig(manager, species, 1.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Albino Silverfish", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        AlbinoSilverfishEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42452_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<AlbinoSilverfishEntity> getVariantFactory() {
        return AlbinoSilverfishEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends AlbinoSilverfishEntity> getSpecies() {
        return SPECIES;
    }

    public AlbinoSilverfishEntity(EntityType<? extends _SpecialSilverfishEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected int getVariantSpitColor() {
        return MobEffects.f_19597_.m_19484_();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19597_, 2);
    }
}

