/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.silverfish;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.species.DesiccatedSilverfishSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.silverfish._SpecialSilverfishEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

@SpecialMob
public class DesiccatedSilverfishEntity
extends _SpecialSilverfishEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<DesiccatedSilverfishEntity> SPECIES;
    private int absorbCount;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xE7E7E7).theme(BestiaryInfo.Theme.DESERT).uniqueTextureBaseOnly().addExperience(1).undead().addToAttribute(Attributes.f_22276_, 4.0).addToAttribute(Attributes.f_22284_, 2.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new DesiccatedSilverfishSpeciesConfig(manager, species, 0.05, 64, 64);
    }

    @Override
    public DesiccatedSilverfishSpeciesConfig getConfig() {
        return (DesiccatedSilverfishSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Desiccated Silverfish", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        DesiccatedSilverfishEntity.addBaseLoot(loot);
        loot.addLootTable("common", EntityType.f_20501_.m_20677_());
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<DesiccatedSilverfishEntity> getVariantFactory() {
        return DesiccatedSilverfishEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends DesiccatedSilverfishEntity> getSpecies() {
        return SPECIES;
    }

    public DesiccatedSilverfishEntity(EntityType<? extends _SpecialSilverfishEntity> entityType, Level level) {
        super(entityType, level);
        this.absorbCount = this.getConfig().DESICCATED.absorbCount.next(this.f_19796_);
    }

    @Override
    public void m_8107_() {
        if (!this.m_9236_().m_5776_() && this.absorbCount > 0 && this.spongebob()) {
            this.m_21373_();
        }
        super.m_8107_();
    }

    @Override
    protected int getVariantSpitColor() {
        return MobEffects.f_19612_.m_19484_();
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19612_);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    private boolean spongebob() {
        int initialCount = this.absorbCount;
        ArrayDeque<Tuple<BlockPos, Integer>> posToCheckAround = new ArrayDeque<Tuple<BlockPos, Integer>>();
        this.tryAbsorb(posToCheckAround, -1, this.m_20183_());
        block0: while (!posToCheckAround.isEmpty() && this.absorbCount > 0) {
            Tuple tuple = (Tuple)posToCheckAround.poll();
            BlockPos rootPos = (BlockPos)tuple.m_14418_();
            int rootDistance = (Integer)tuple.m_14419_();
            for (Direction direction : Direction.values()) {
                this.tryAbsorb(posToCheckAround, rootDistance, rootPos.m_121945_(direction));
                if (this.absorbCount <= 0) continue block0;
            }
        }
        return initialCount > this.absorbCount;
    }

    private void tryAbsorb(Queue<Tuple<BlockPos, Integer>> posToCheckAround, int rootDistance, BlockPos pos) {
        if (!this.m_9236_().m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
            return;
        }
        BlockState block = this.m_9236_().m_8055_(pos);
        if (block.m_60734_() instanceof BucketPickup && ((BucketPickup)block.m_60734_()).m_142598_((LevelAccessor)this.m_9236_(), pos, block) != ItemStack.f_41583_) {
            this.onAbsorb(posToCheckAround, rootDistance, pos);
        } else if (block.m_60734_() instanceof LiquidBlock) {
            this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            this.onAbsorb(posToCheckAround, rootDistance, pos);
        } else if (block.m_204336_(BlockTags.f_278394_)) {
            BlockEntity blockEntity = block.m_155947_() ? this.m_9236_().getExistingBlockEntity(pos) : null;
            Block.m_49892_((BlockState)block, (LevelAccessor)this.m_9236_(), (BlockPos)pos, (BlockEntity)blockEntity);
            this.m_9236_().m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
            this.onAbsorb(posToCheckAround, rootDistance, pos);
        }
    }

    private void onAbsorb(Queue<Tuple<BlockPos, Integer>> posToCheckAround, int rootDistance, BlockPos pos) {
        if (rootDistance < 6) {
            posToCheckAround.add((Tuple<BlockPos, Integer>)new Tuple((Object)pos, (Object)(rootDistance + 1)));
        }
        this.m_5634_(1.0f);
        --this.absorbCount;
    }

    @Override
    public void addVariantSaveData(CompoundTag saveTag) {
        saveTag.m_128344_("Ammo", (byte)this.absorbCount);
    }

    @Override
    public void readVariantSaveData(CompoundTag saveTag) {
        if (saveTag.m_128425_("Ammo", 99)) {
            this.absorbCount = saveTag.m_128445_("Ammo");
        }
    }
}

