/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.silverfish;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.config.family.SilverfishFamilyConfig;
import fathertoast.specialmobs.common.config.species.SilverfishSpeciesConfig;
import fathertoast.specialmobs.common.config.species.SpeciesConfig;
import fathertoast.specialmobs.common.core.register.SMTags;
import fathertoast.specialmobs.common.entity.ISpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.SpecialMobData;
import fathertoast.specialmobs.common.entity.ai.AIHelper;
import fathertoast.specialmobs.common.entity.ai.goal.PassiveRangedAttackGoal;
import fathertoast.specialmobs.common.entity.ai.goal.SpecialHurtByTargetGoal;
import fathertoast.specialmobs.common.entity.projectile.BugSpitEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.monster.Silverfish;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Snowball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

@SpecialMob
public class _SpecialSilverfishEntity
extends Silverfish
implements RangedAttackMob,
ISpecialMob<_SpecialSilverfishEntity> {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<_SpecialSilverfishEntity> SPECIES;
    protected static final double DEFAULT_SPIT_CHANCE = 0.05;
    private static final EntityDataAccessor<Float> SCALE;
    private SpecialMobData<_SpecialSilverfishEntity> specialData;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x303030).modBaseTexture("textures/entity/silverfish/base_silverfish.png").experience(5).spitAttack(1.0, 1.0, 30, 60, 10.0);
    }

    @SpecialMob.ConfigSupplier
    public static SpeciesConfig createConfig(ConfigManager manager, MobFamily.Species<?> species) {
        return new SilverfishSpeciesConfig(manager, species, 0.05);
    }

    public SilverfishSpeciesConfig getConfig() {
        return (SilverfishSpeciesConfig)this.getSpecies().config;
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_33551_() {
        return Silverfish.m_33551_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpawnPlacement(MobFamily.Species<? extends _SpecialSilverfishEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, _SpecialSilverfishEntity::checkFamilySpawnRules);
    }

    public static boolean checkFamilySpawnRules(EntityType<? extends Silverfish> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Silverfish.m_219076_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && NaturalSpawnManager.checkSpawnRulesConfigured(type, level, spawnType, pos, random);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Silverfish", "Lepisma", "Lepisma", "Poisson d'argent", "Pesciolino d'argento", "Silberfischchen", "Bilge Rat");
    }

    @SpecialMob.LootTableProvider
    public static void addBaseLoot(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20523_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(SMTags.EntityTypes.SILVERFISH, EntityTypeTags.f_144291_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<_SpecialSilverfishEntity> getFactory() {
        return _SpecialSilverfishEntity::new;
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, new PassiveRangedAttackGoal<_SpecialSilverfishEntity>(this));
        AIHelper.replaceHurtByTarget((PathfinderMob)this, new SpecialHurtByTargetGoal((PathfinderMob)this, Silverfish.class, new Class[0]).setAlertOthers(new Class[0]));
        this.registerVariantGoals();
    }

    protected void registerVariantGoals() {
    }

    public void finalizeVariantSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
    }

    public void m_6504_(LivingEntity target, float damageMulti) {
        BugSpitEntity spit = new BugSpitEntity((LivingEntity)this, target);
        spit.setColor(this.getVariantSpitColor());
        this.m_5496_(SoundEvents.f_12421_, 0.6f, this.f_19796_.m_188501_() * 0.4f + 1.6f);
        this.m_9236_().m_7967_((Entity)spit);
    }

    protected int getVariantSpitColor() {
        return MapColor.f_283947_.f_283871_;
    }

    public void m_19970_(LivingEntity attacker, Entity target) {
        if (target instanceof LivingEntity) {
            this.onVariantAttack((LivingEntity)target);
        }
        super.m_19970_(attacker, target);
    }

    protected void onVariantAttack(LivingEntity target) {
    }

    public void addVariantSaveData(CompoundTag saveTag) {
    }

    public void readVariantSaveData(CompoundTag saveTag) {
    }

    public _SpecialSilverfishEntity(EntityType<? extends _SpecialSilverfishEntity> entityType, Level level) {
        super(entityType, level);
        if (!this.getConfig().SILVERFISH.spitterChance.rollChance(this.f_19796_)) {
            this.getSpecialData().disableRangedAttack();
        }
        this.getSpecialData().initialize();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.specialData = new SpecialMobData<_SpecialSilverfishEntity>(this, SCALE);
    }

    @Override
    public SpecialMobData<_SpecialSilverfishEntity> getSpecialData() {
        return this.specialData;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends _SpecialSilverfishEntity> getSpecies() {
        return SPECIES;
    }

    @Override
    public final int getExperience() {
        return this.f_21364_;
    }

    @Override
    public final void setExperience(int xp) {
        this.f_21364_ = xp;
    }

    @Nullable
    public <T extends Mob> T m_21406_(EntityType<T> entityType, boolean keepEquipment) {
        Level level;
        Mob replacement = super.m_21406_(entityType, keepEquipment);
        if (replacement instanceof ISpecialMob && (level = this.m_9236_()) instanceof ServerLevelAccessor) {
            ServerLevelAccessor serverLevel = (ServerLevelAccessor)level;
            MobHelper.finalizeSpawn((LivingEntity)replacement, serverLevel, this.m_9236_().m_6436_(this.m_20183_()), MobSpawnType.CONVERSION, null);
        }
        return (T)replacement;
    }

    @Nullable
    public final SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag eggTag) {
        return MobHelper.finalizeSpawn((LivingEntity)this, level, difficulty, spawnType, super.m_6518_(level, difficulty, spawnType, groupData, eggTag));
    }

    @Override
    public void setSpecialPathfindingMalus(BlockPathTypes types, float malus) {
        this.m_21441_(types, malus);
    }

    protected final void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
    }

    @Override
    public void finalizeSpecialSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, @Nullable MobSpawnType spawnType, @Nullable SpawnGroupData groupData) {
        double aggressiveChance;
        double d = aggressiveChance = this.getConfig().SILVERFISH.aggressiveChance.get() < 0.0 ? ((SilverfishFamilyConfig)((Object)MobFamily.SILVERFISH.config)).SILVERFISH.familyAggressiveChance.get() : this.getConfig().SILVERFISH.aggressiveChance.get();
        if (this.f_19796_.m_188500_() < aggressiveChance) {
            if (this.m_5448_() == null) {
                double followRange = this.m_21133_(Attributes.f_22277_);
                List nearbyPlayers = level.m_45955_(TargetingConditions.f_26872_.m_26883_(followRange), (LivingEntity)this, this.m_20191_().m_82377_(followRange, followRange, followRange));
                for (Player player : nearbyPlayers) {
                    if (player == null || !this.m_142582_((Entity)player)) continue;
                    this.m_6710_((LivingEntity)player);
                    break;
                }
            }
            if (this.m_5448_() != null) {
                this.m_6469_(this.m_269291_().m_269425_(), 0.0f);
            }
        }
        this.finalizeVariantSpawn(level, difficulty, spawnType, groupData);
    }

    public void m_8107_() {
        super.m_8107_();
        this.getSpecialData().tick();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return super.m_6431_(pose, size) * this.getSpecialData().getHeightScaleByAge();
    }

    public boolean m_5825_() {
        return this.getSpecialData().isImmuneToFire();
    }

    public void m_7311_(int ticks) {
        if (!this.getSpecialData().isImmuneToBurning()) {
            super.m_7311_(ticks);
        }
    }

    public boolean m_6573_(Player player) {
        return !this.m_21523_() && this.getSpecialData().allowLeashing();
    }

    public void m_7601_(BlockState block, Vec3 speedMulti) {
        if (this.getSpecialData().canBeStuckIn(block)) {
            super.m_7601_(block, speedMulti);
        }
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource damageSource) {
        return super.m_142535_(distance, damageMultiplier * this.getSpecialData().getFallDamageMultiplier(), damageSource);
    }

    public boolean m_6090_() {
        return this.getSpecialData().ignorePressurePlates();
    }

    public boolean m_6040_() {
        return this.getSpecialData().canBreatheInWater();
    }

    public boolean m_6063_() {
        return !this.getSpecialData().ignoreWaterPush();
    }

    public boolean m_6126_() {
        return this.getSpecialData().isDamagedByWater();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6126_() && source.m_7640_() instanceof Snowball) {
            amount = Math.max(3.0f, amount);
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7301_(MobEffectInstance effect) {
        return this.getSpecialData().isPotionApplicable(effect);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().writeToNBT(saveTag);
        this.addVariantSaveData(saveTag);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        CompoundTag saveTag = SpecialMobData.getSaveLocation(tag);
        this.getSpecialData().readFromNBT(saveTag);
        this.readVariantSaveData(saveTag);
    }

    static {
        SCALE = SynchedEntityData.m_135353_(_SpecialSilverfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    }
}

