/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class FireSkeletonEntity
extends _SpecialSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<FireSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(14424576).theme(BestiaryInfo.Theme.FIRE).uniqueTextureWithEyes().addExperience(1).fireImmune().waterSensitive();
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Fire Skeleton", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        FireSkeletonEntity.addBaseLoot(loot);
        loot.addCommonDrop("common", (ItemLike)Items.f_42613_);
        loot.addUncommonDrop("uncommon", new ItemLike[]{Items.f_42413_});
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(EntityTypeTags.f_13120_, EntityTypeTags.f_144295_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<FireSkeletonEntity> getVariantFactory() {
        return FireSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends FireSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public FireSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        target.m_20254_(10);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        arrow.m_20254_(100);
        return arrow;
    }
}

