/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

@SpecialMob
public class GiantSkeletonEntity
extends _SpecialSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<GiantSkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0x494949).theme(BestiaryInfo.Theme.MOUNTAIN).modBaseTexture("textures/entity/skeleton/base_skeleton.png").size(1.5f, 0.9f, 2.99f).addExperience(1).addToAttribute(Attributes.f_22276_, 20.0).addToAttribute(Attributes.f_22281_, 2.0).addToRangedDamage(2.0);
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Giant Skeleton", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        GiantSkeletonEntity.addBaseLoot(loot);
        loot.addGuaranteedDrop("base", (ItemLike)Items.f_42500_, 2);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<GiantSkeletonEntity> getVariantFactory() {
        return GiantSkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends GiantSkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public GiantSkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    public float getStepHeight() {
        return 1.0f;
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.knockback((Entity)this, target, 4.0f, 0.5f);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        arrow.m_36735_(arrow.m_150123_() + 2);
        return arrow;
    }

    @Override
    public void m_6863_(boolean value) {
    }

    @Override
    public boolean m_6162_() {
        return false;
    }
}

