/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialmobs.common.entity.skeleton;

import fathertoast.specialmobs.common.bestiary.BestiaryInfo;
import fathertoast.specialmobs.common.bestiary.MobFamily;
import fathertoast.specialmobs.common.bestiary.SpecialMob;
import fathertoast.specialmobs.common.entity.MobHelper;
import fathertoast.specialmobs.common.entity.skeleton._SpecialSkeletonEntity;
import fathertoast.specialmobs.common.event.NaturalSpawnManager;
import fathertoast.specialmobs.common.util.References;
import fathertoast.specialmobs.datagen.loot.LootTableBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.monster.Stray;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

@SpecialMob
public class StraySkeletonEntity
extends _SpecialSkeletonEntity {
    @SpecialMob.SpeciesReference
    public static MobFamily.Species<StraySkeletonEntity> SPECIES;

    @SpecialMob.BestiaryInfoSupplier
    public static void getBestiaryInfo(BestiaryInfo.Builder bestiaryInfo) {
        bestiaryInfo.color(0xDDEAEA).weight(BestiaryInfo.DefaultWeight.LOW).theme(BestiaryInfo.Theme.ICE).modBaseTexture("textures/entity/skeleton/base_stray.png").modOverlayTexture("textures/entity/skeleton/base_stray_overlay.png").addExperience(1);
    }

    @SpecialMob.AttributeSupplier
    public static AttributeSupplier.Builder m_32166_() {
        return Stray.m_32166_();
    }

    @SpecialMob.SpawnPlacementRegistrar
    public static void registerSpeciesSpawnPlacement(MobFamily.Species<? extends StraySkeletonEntity> species) {
        NaturalSpawnManager.registerSpawnPlacement(species, StraySkeletonEntity::checkSpeciesSpawnRules);
    }

    public static boolean checkSpeciesSpawnRules(EntityType<? extends StraySkeletonEntity> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return NaturalSpawnManager.checkSpawnRulesDefault(type, level, spawnType, pos, random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }

    @SpecialMob.LanguageProvider
    public static String[] getTranslations(String langKey) {
        return References.translations(langKey, "Stray", "", "", "", "", "", "");
    }

    @SpecialMob.LootTableProvider
    public static void buildLootTable(LootTableBuilder loot) {
        loot.addLootTable("main", EntityType.f_20481_.m_20677_());
    }

    @SpecialMob.EntityTagProvider
    public static List<TagKey<EntityType<?>>> getEntityTags() {
        return List.of(EntityTypeTags.f_13120_, EntityTypeTags.f_144294_);
    }

    @SpecialMob.Factory
    public static EntityType.EntityFactory<StraySkeletonEntity> getVariantFactory() {
        return StraySkeletonEntity::new;
    }

    @Override
    @SpecialMob.SpeciesSupplier
    public MobFamily.Species<? extends StraySkeletonEntity> getSpecies() {
        return SPECIES;
    }

    public StraySkeletonEntity(EntityType<? extends _SpecialSkeletonEntity> entityType, Level level) {
        super(entityType, level);
    }

    @Override
    protected void onVariantAttack(LivingEntity target) {
        MobHelper.applyEffect(target, MobEffects.f_19597_, 2.0f);
    }

    @Override
    protected AbstractArrow getVariantArrow(AbstractArrow arrow, ItemStack arrowItem, float damageMulti) {
        return MobHelper.tipArrow(arrow, MobEffects.f_19597_, 2.0f);
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_12451_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12453_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12452_;
    }

    @Override
    protected SoundEvent m_7878_() {
        return SoundEvents.f_12454_;
    }
}

